/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.annotation.Annotations;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.pkg.container.AnnotsDir;
import org.ofdrw.pkg.container.PagesDir;
import org.ofdrw.pkg.container.ResDir;
import org.ofdrw.pkg.container.SignsDir;
import org.ofdrw.pkg.container.TempsDir;
import org.ofdrw.pkg.container.VirtualContainer;

public class DocDir
extends VirtualContainer {
    public static final String DocContainerPrefix = "Doc_";
    public static final String DocumentFileName = "Document.xml";
    public static final String PublicResFileName = "PublicRes.xml";
    public static final String DocumentResFileName = "DocumentRes.xml";
    public static final String SignsDir = "Signs";
    public static final String SignContainerPrefix = "Sign_";
    public static final String TagsDir = "Tags";
    public static final String TempsDir = "Temps";
    public static final String PagesDir = "Pages";
    public static final String PageContainerPrefix = "Page_";
    public static final String ResDir = "Res";
    public static final String AnnotsDir = "Annots";
    public static final String AnnotationsFileName = "Annotations.xml";
    public static final String Attachments = "Attachments.xml";
    private int index = 0;

    public DocDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
        String indexStr = this.getContainerName().replace(DocContainerPrefix, "");
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            this.clean();
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u76ee\u5f55\u540d\u79f0\uff1a" + this.getContainerName() + "\uff0c\u76ee\u5f55\u540d\u79f0\u5e94\u4e3a Doc_N");
        }
    }

    public Integer getIndex() {
        return this.index;
    }

    public Document getDocument() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(DocumentFileName);
        return new Document(obj);
    }

    public DocDir setDocument(Document document) {
        this.putObj(DocumentFileName, (Element)document);
        return this;
    }

    public Res getPublicRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(PublicResFileName);
        return new Res(obj);
    }

    public DocDir setPublicRes(Res publicRes) {
        this.putObj(PublicResFileName, (Element)publicRes);
        return this;
    }

    public Res getDocumentRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(DocumentResFileName);
        return new Res(obj);
    }

    public Annotations getAnnotations() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(AnnotationsFileName);
        return new Annotations(obj);
    }

    public DocDir setAnnotations(Annotations annotations) {
        this.putObj(AnnotationsFileName, (Element)annotations);
        return this;
    }

    public DocDir setDocumentRes(Res documentRes) {
        this.putObj(DocumentResFileName, (Element)documentRes);
        return this;
    }

    public ResDir getRes() throws FileNotFoundException {
        return this.getContainer(ResDir, ResDir::new);
    }

    public ResDir obtainRes() {
        return this.obtainContainer(ResDir, ResDir::new);
    }

    public SignsDir getSigns() throws FileNotFoundException {
        return this.getContainer(SignsDir, SignsDir::new);
    }

    public SignsDir obtainSigns() {
        return this.obtainContainer(SignsDir, SignsDir::new);
    }

    public PagesDir getPages() throws FileNotFoundException {
        return this.getContainer(PagesDir, PagesDir::new);
    }

    public PagesDir obtainPages() {
        return this.obtainContainer(PagesDir, PagesDir::new);
    }

    public VirtualContainer obtainTags() {
        return this.obtainContainer(TagsDir, VirtualContainer::new);
    }

    public VirtualContainer getTags() throws FileNotFoundException {
        return this.getContainer(TagsDir, VirtualContainer::new);
    }

    public TempsDir obtainTemps() {
        return this.obtainContainer(TempsDir, TempsDir::new);
    }

    public TempsDir getTemps() throws FileNotFoundException {
        return this.getContainer(TempsDir, TempsDir::new);
    }

    public AnnotsDir obtainAnnots() {
        return this.obtainContainer(AnnotsDir, AnnotsDir::new);
    }

    public AnnotsDir getAnnots() throws FileNotFoundException {
        return this.getContainer(AnnotsDir, AnnotsDir::new);
    }

    public DocDir addResource(Path resource) throws IOException {
        this.obtainRes().add(resource);
        return this;
    }

    public Path getResource(String name) throws FileNotFoundException {
        return this.obtainRes().get(name);
    }
}

