/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.layout.element.canvas.Canvas;
import org.ofdrw.layout.element.canvas.DrawContext;
import org.ofdrw.layout.element.canvas.Drawer;
import org.ofdrw.layout.element.canvas.TextAlign;
import org.ofdrw.layout.element.canvas.TextMetrics;
import org.ofdrw.layout.element.canvas.VerticalAlign;

public class CellContentDrawer
implements Drawer {
    public static Boolean DEBUG = false;
    private final Canvas canvas;
    private String value;
    private TextAlign textAlign = TextAlign.left;
    private VerticalAlign verticalAlign = VerticalAlign.center;
    private String color = "#000000";
    private String fontName = "\u5b8b\u4f53";
    private double fontSize = 3.0;
    private Double lineSpace = 0.6;
    private Boolean bold = false;
    private Boolean italic = false;
    private Double letterSpacing = 0.0;
    private Img img = null;
    private boolean underline = false;
    private boolean deleteLine = false;

    public CellContentDrawer(Canvas canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("Canvas \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.canvas = canvas;
        canvas.setDrawer(this);
    }

    public CellContentDrawer(double x, double y, double width, double height) {
        this.canvas = new Canvas(x, y, width, height);
        this.canvas.setDrawer(this);
    }

    @Override
    public void draw(DrawContext ctx) throws IOException {
        ctx.save();
        try {
            if (this.img != null) {
                this.drawImg(ctx);
            } else {
                this.drawText(ctx);
            }
        }
        finally {
            ctx.restore();
        }
    }

    private void drawImg(DrawContext ctx) throws IOException {
        if (this.img == null) {
            return;
        }
        if (this.img.width <= 0.0 || this.img.height <= 0.0) {
            BufferedImage gImg = ImageIO.read(this.img.path.toFile());
            this.img.width = ctx.mm(gImg.getWidth());
            this.img.height = ctx.mm(gImg.getHeight());
            if (DEBUG.booleanValue()) {
                System.out.printf(">> \u4ece\u56fe\u7247\u4e2d\u83b7\u53d6\u5bbd\u9ad8 img.width:%.2f img.height:%.2f\n", this.img.width, this.img.height);
            }
        }
        double x = 0.0;
        switch (this.textAlign) {
            case right: 
            case end: {
                x = this.canvas.getWidth() - this.img.width;
                break;
            }
            case center: {
                x = (this.canvas.getWidth() - this.img.width) / 2.0;
                break;
            }
            default: {
                x = 0.0;
            }
        }
        double y = 0.0;
        switch (this.verticalAlign) {
            case bottom: {
                y = this.canvas.getHeight() - this.img.height;
                break;
            }
            case center: {
                y = (this.canvas.getHeight() - this.img.height) / 2.0;
                break;
            }
            default: {
                y = 0.0;
            }
        }
        ctx.drawImage(this.img.path, x, y, this.img.width, this.img.height);
        if (DEBUG.booleanValue()) {
            this.debugBorder(ctx);
        }
    }

    private void drawText(DrawContext ctx) throws IOException {
        if (this.value == null || this.value.isEmpty()) {
            return;
        }
        String fontStr = "";
        if (this.italic.booleanValue()) {
            fontStr = fontStr + "italic ";
        }
        if (this.bold.booleanValue()) {
            fontStr = fontStr + "bold ";
        }
        ctx.font = fontStr + STBase.fmt((double)this.fontSize) + "mm " + this.fontName;
        if (this.letterSpacing != 0.0) {
            ctx.getFont().setLetterSpacing(this.letterSpacing);
        }
        if (this.color != null && !this.color.isEmpty()) {
            ctx.fillStyle = this.color;
        }
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        TextMetrics textMetrics = ctx.measureText(this.value);
        LinkedList<TextLine> lines = new LinkedList<TextLine>();
        double textLineWidth = 0.0;
        int offset = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\n') {
                lines.add(new TextLine(this.value.substring(offset, i), textLineWidth));
                offset = i + 1;
                textLineWidth = 0.0;
                continue;
            }
            double cWidth = 0.0;
            cWidth = i == this.value.length() - 1 ? ctx.measureText((String)String.valueOf((char)c)).width.doubleValue() : textMetrics.offset[i].doubleValue();
            if (textLineWidth + cWidth > width) {
                lines.add(new TextLine(this.value.substring(offset, i), textLineWidth));
                offset = i;
                textLineWidth = cWidth;
                continue;
            }
            textLineWidth += cWidth;
        }
        if (offset < this.value.length()) {
            lines.add(new TextLine(this.value.substring(offset), textLineWidth));
        }
        double contentHeight = (this.fontSize + this.lineSpace) * (double)lines.size();
        double offsetY = 0.0;
        offsetY = this.verticalAlign == VerticalAlign.top ? this.fontSize : (this.verticalAlign == VerticalAlign.center ? height / 2.0 - contentHeight / 2.0 + this.fontSize : height - contentHeight + this.fontSize);
        for (TextLine line : lines) {
            double offsetX = 0.0;
            offsetX = this.textAlign == TextAlign.left || this.textAlign == TextAlign.start || this.textAlign == null ? 0.0 : (this.textAlign == TextAlign.center ? (width - line.width) / 2.0 : width - line.width);
            if (!"".equals(line.text)) {
                ctx.fillText(line.text, offsetX, offsetY);
            }
            double fontLineWidth = this.fontSize / 30.0;
            double underlineOffset = fontLineWidth * 3.2;
            if (this.underline) {
                ctx.save();
                ctx.setLineWidth(fontLineWidth);
                ctx.beginPath();
                ctx.moveTo(offsetX, offsetY + underlineOffset);
                ctx.lineTo(offsetX + line.width, offsetY + underlineOffset);
                ctx.stroke();
                ctx.restore();
            }
            if (this.deleteLine) {
                ctx.save();
                ctx.setLineWidth(fontLineWidth);
                ctx.beginPath();
                ctx.moveTo(offsetX, offsetY - this.fontSize * 5.0 / 18.0);
                ctx.lineTo(offsetX + line.width, offsetY - this.fontSize * 5.0 / 18.0);
                ctx.stroke();
                ctx.restore();
            }
            if (DEBUG.booleanValue()) {
                ctx.save();
                ctx.setLineDash(1.5, 1.5);
                ctx.setLineWidth(0.1);
                ctx.setGlobalAlpha(0.53);
                ctx.strokeStyle = "rgb(255,0,0)";
                ctx.strokeRect(offsetX, offsetY - this.fontSize, line.width, this.fontSize + this.lineSpace);
                ctx.stroke();
                ctx.restore();
            }
            offsetY += this.fontSize + this.lineSpace;
        }
        if (DEBUG.booleanValue()) {
            this.debugBorder(ctx);
        }
    }

    private void debugBorder(DrawContext ctx) {
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        ctx.save();
        double lineWidth = 0.353;
        ctx.setLineDash(1.5, 1.5);
        ctx.setLineWidth(lineWidth);
        ctx.setGlobalAlpha(0.53);
        ctx.strokeStyle = "rgb(255,0,0)";
        ctx.moveTo(0.0, 0.0);
        ctx.lineTo(width, height);
        ctx.moveTo(width, 0.0);
        ctx.lineTo(0.0, height);
        ctx.rect(0.0, 0.0, width, height);
        ctx.stroke();
        ctx.restore();
    }

    public String getValue() {
        return this.value;
    }

    public CellContentDrawer setValue(String value) {
        this.value = value;
        return this;
    }

    public CellContentDrawer setValue(Path imgPath, double w, double h) {
        this.img = new Img(imgPath, w, h);
        return this;
    }

    public CellContentDrawer setValue(Path imgPath) throws IOException {
        this.img = new Img(imgPath, 0.0, 0.0);
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public CellContentDrawer setColor(String color) {
        if (color == null || color.isEmpty()) {
            throw new IllegalArgumentException("\u989c\u8272(color)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.color = color;
        return this;
    }

    public String getFontName() {
        return this.fontName;
    }

    public CellContentDrawer setFontName(String fontName) {
        this.fontName = fontName;
        return this;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public CellContentDrawer setFontSize(double fontSize) {
        if (fontSize <= 0.0) {
            throw new IllegalArgumentException("\u5b57\u53f7(fontSize)\u5fc5\u987b\u5927\u4e8e0");
        }
        this.fontSize = fontSize;
        return this;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public CellContentDrawer setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public CellContentDrawer setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
        return this;
    }

    public Double getLineSpace() {
        return this.lineSpace;
    }

    public CellContentDrawer setLineSpace(Double lineSpace) {
        this.lineSpace = lineSpace;
        return this;
    }

    @Deprecated
    public Boolean getBlob() {
        return this.bold;
    }

    @Deprecated
    public CellContentDrawer setBlob(Boolean bolb) {
        this.bold = bolb;
        return this;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public CellContentDrawer setBold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public CellContentDrawer setItalic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    public Double getLetterSpacing() {
        return this.letterSpacing;
    }

    public CellContentDrawer setLetterSpacing(Double letterSpacing) {
        this.letterSpacing = letterSpacing;
        return this;
    }

    public Path getImgPath() {
        if (this.img == null) {
            return null;
        }
        return this.img.path;
    }

    public double getImgWidth() {
        if (this.img == null) {
            return 0.0;
        }
        return this.img.width;
    }

    public double getImgHeight() {
        if (this.img == null) {
            return 0.0;
        }
        return this.img.height;
    }

    public CellContentDrawer setUnderline(boolean underline) {
        this.underline = underline;
        return this;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public CellContentDrawer setDeleteLine(boolean deleteLine) {
        this.deleteLine = deleteLine;
        return this;
    }

    public boolean getDeleteLine() {
        return this.deleteLine;
    }

    private static class Img {
        public Path path;
        public double width;
        public double height;

        public Img(Path path, double width, double height) {
            this.path = path;
            this.width = width;
            this.height = height;
        }
    }

    private static class TextLine {
        public String text;
        public double width;

        public TextLine(String text, double width) {
            this.text = text;
            this.width = width;
            if (DEBUG.booleanValue()) {
                System.out.println(">> text:" + text + " width:" + width);
            }
        }
    }
}

