/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.graph.pathObj;

import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.graph.pathObj.OptVal;

public class AbbreviatedData
extends OFDElement
implements Cloneable {
    private LinkedList<OptVal> dataQueue;

    public AbbreviatedData(Element proxy) {
        super(proxy);
        this.dataQueue = AbbreviatedData.parse(proxy.getText());
    }

    public AbbreviatedData() {
        super("AbbreviatedData");
        this.dataQueue = new LinkedList();
    }

    public AbbreviatedData(List<OptVal> list) {
        this();
        this.dataQueue = new LinkedList<OptVal>(list);
    }

    public static LinkedList<OptVal> parse(String dataStr) {
        if (dataStr == null || dataStr.length() == 0) {
            return new LinkedList<OptVal>();
        }
        String[] arr = dataStr.split("\\s+");
        LinkedList<OptVal> res = new LinkedList<OptVal>();
        String opt = null;
        LinkedList<String> values = new LinkedList<String>();
        String[] stringArray = arr;
        int n = stringArray.length;
        block13: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "S": 
                case "M": 
                case "L": 
                case "Q": 
                case "B": 
                case "A": 
                case "C": 
                case "CM": {
                    if (opt != null) {
                        res.add(new OptVal(opt, values));
                        values.clear();
                        opt = null;
                    }
                    opt = s;
                    continue block13;
                }
                default: {
                    values.add(s);
                }
            }
        }
        if (opt != null) {
            res.add(new OptVal(opt, values));
        }
        return res;
    }

    public LinkedList<OptVal> getRawOptVal() {
        return this.dataQueue;
    }

    public AbbreviatedData flush() {
        this.setText(this.toString());
        return this;
    }

    public AbbreviatedData defineStart(double x, double y) {
        this.dataQueue.add(new OptVal("S", new double[]{x, y}));
        return this;
    }

    public AbbreviatedData s(ST_Pos start) {
        return this.defineStart(start.getX(), start.getY());
    }

    public AbbreviatedData S(double x, double y) {
        return this.defineStart(x, y);
    }

    public AbbreviatedData moveTo(double x, double y) {
        this.dataQueue.add(new OptVal("M", new double[]{x, y}));
        return this;
    }

    public AbbreviatedData M(double x, double y) {
        return this.moveTo(x, y);
    }

    public AbbreviatedData M(ST_Pos target) {
        return this.moveTo(target.getX(), target.getY());
    }

    public AbbreviatedData lineTo(double x, double y) {
        this.dataQueue.add(new OptVal("L", new double[]{x, y}));
        return this;
    }

    public AbbreviatedData L(double x, double y) {
        return this.lineTo(x, y);
    }

    public AbbreviatedData L(ST_Pos p) {
        return this.lineTo(p.getX(), p.getY());
    }

    public AbbreviatedData quadraticBezier(double x1, double y1, double x2, double y2) {
        this.dataQueue.add(new OptVal("Q", new double[]{x1, y1, x2, y2}));
        return this;
    }

    public AbbreviatedData Q(double x1, double y1, double x2, double y2) {
        return this.quadraticBezier(x1, y1, x2, y2);
    }

    public AbbreviatedData Q(ST_Pos control, ST_Pos target) {
        return this.quadraticBezier(control.getX(), control.getY(), target.getX(), target.getY());
    }

    public AbbreviatedData cubicBezier(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.dataQueue.add(new OptVal("B", new double[]{x1, y1, x2, y2, x3, y3}));
        return this;
    }

    public AbbreviatedData B(double x1, double y1, double x2, double y2, double x3, double y3) {
        return this.cubicBezier(x1, y1, x2, y2, x3, y3);
    }

    public AbbreviatedData B(ST_Pos control1, ST_Pos control2, ST_Pos target) {
        return this.cubicBezier(control1.getX(), control1.getY(), control2.getX(), control2.getY(), target.getX(), target.getY());
    }

    public AbbreviatedData arc(double rx, double ry, double angle, int large, int sweep, double x, double y) {
        if (large != 0 && large != 1) {
            throw new NumberFormatException("large \u53ea\u63a5\u53d7 0 \u6216 1");
        }
        if (sweep != 0 && sweep != 1) {
            throw new NumberFormatException("sweep \u53ea\u63a5\u53d7 0 \u6216 1");
        }
        this.dataQueue.add(new OptVal("A", new double[]{rx, ry, angle, large, sweep, x, y}));
        return this;
    }

    public AbbreviatedData A(double rx, double ry, double angle, int large, int sweep, double x, double y) {
        return this.arc(rx, ry, angle, large, sweep, x, y);
    }

    public AbbreviatedData A(double rx, double ry, double angle, int large, int sweep, ST_Pos target) {
        return this.arc(rx, ry, angle, large, sweep, target.getX(), target.getY());
    }

    public AbbreviatedData close() {
        this.dataQueue.add(new OptVal("C"));
        return this;
    }

    public AbbreviatedData C() {
        return this.close();
    }

    public AbbreviatedData undo() {
        this.dataQueue.removeLast();
        return this;
    }

    public String toString() {
        if (this.dataQueue.size() == 0) {
            throw new IllegalArgumentException("AbbreviatedData \u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder dataBuilder = new StringBuilder();
        int cnt = 0;
        for (OptVal operatorItem : this.dataQueue) {
            if (++cnt != 1) {
                dataBuilder.append(" ");
            }
            dataBuilder.append(operatorItem.toString());
        }
        return dataBuilder.toString();
    }

    @Override
    public AbbreviatedData clone() {
        AbbreviatedData clone = new AbbreviatedData();
        clone.dataQueue = new LinkedList();
        for (OptVal item : this.dataQueue) {
            clone.dataQueue.add(item.clone());
        }
        clone.flush();
        return clone;
    }
}

