/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;
import org.ofdrw.converter.point.PathPoint;
import org.ofdrw.converter.point.TextCodePoint;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.reader.DeltaTool;

public class PointUtil {
    private static final Logger logger = LoggerFactory.getLogger(PointUtil.class);

    public static List<PathPoint> convertPathAbbreviatedDatatoPoint(String abbreviatedData) {
        ArrayList<PathPoint> pointList = new ArrayList<PathPoint>();
        String[] array = abbreviatedData.split(" ");
        int i = 0;
        while (i < array.length) {
            PathPoint point;
            if (array[i].equals("M")) {
                point = new PathPoint("M", (float)Double.parseDouble(array[i + 1]), (float)Double.parseDouble(array[i + 2]), 0.0f, 0.0f, 0.0f, 0.0f);
                i += 3;
                pointList.add(point);
            }
            if (array[i].equals("L")) {
                point = new PathPoint("L", (float)Double.parseDouble(array[i + 1]), (float)Double.parseDouble(array[i + 2]), 0.0f, 0.0f, 0.0f, 0.0f);
                i += 3;
                pointList.add(point);
                continue;
            }
            if (array[i].equals("C")) {
                point = new PathPoint("C", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                ++i;
                pointList.add(point);
                continue;
            }
            if (array[i].equals("S")) {
                point = new PathPoint("S", (float)Double.parseDouble(array[i + 1]), (float)Double.parseDouble(array[i + 2]), 0.0f, 0.0f, 0.0f, 0.0f);
                i += 3;
                pointList.add(point);
                continue;
            }
            if (array[i].equals("B")) {
                point = new PathPoint("B", (float)Double.parseDouble(array[i + 1]), (float)Double.parseDouble(array[i + 2]), (float)Double.parseDouble(array[i + 3]), (float)Double.parseDouble(array[i + 4]), (float)Double.parseDouble(array[i + 5]), (float)Double.parseDouble(array[i + 6]));
                i += 7;
                pointList.add(point);
                continue;
            }
            if (array[i].equals("Q")) {
                point = new PathPoint("Q", (float)Double.parseDouble(array[i + 1]), (float)Double.parseDouble(array[i + 2]), (float)Double.parseDouble(array[i + 3]), (float)Double.parseDouble(array[i + 4]), 0.0f, 0.0f);
                i += 5;
                pointList.add(point);
                continue;
            }
            if (array[i].equals("A")) {
                point = new PathPoint("A", (float)Double.parseDouble(array[i + 1]), (float)Double.parseDouble(array[i + 2]), (float)Double.parseDouble(array[i + 3]), (float)Double.parseDouble(array[i + 4]), (float)Double.parseDouble(array[i + 5]), (float)Double.parseDouble(array[i + 6]), (float)Double.parseDouble(array[i + 7]));
                i += 8;
                pointList.add(point);
                continue;
            }
            ++i;
        }
        return pointList;
    }

    public static List<PathPoint> calPathPoint(List<PathPoint> abbreviatedPoint) {
        ArrayList<PathPoint> pointList = new ArrayList<PathPoint>();
        for (PathPoint point : abbreviatedPoint) {
            if (point.type.equals("M") || point.type.equals("L") || point.type.equals("C") || point.type.equals("S")) {
                double x = 0.0;
                double y = 0.0;
                x = point.x1;
                y = point.y1;
                point.x1 = (float)CommonUtil.converterDpi(x);
                point.y1 = (float)CommonUtil.converterDpi(y);
                pointList.add(point);
                continue;
            }
            if (!point.type.equals("B")) continue;
            double x1 = point.x1;
            double y1 = point.y1;
            double x2 = point.x2;
            double y2 = point.y2;
            double x3 = point.x3;
            double y3 = point.y3;
            PathPoint realPoint = new PathPoint("B", (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(y1), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(y2), (float)CommonUtil.converterDpi(x3), (float)CommonUtil.converterDpi(y3));
            pointList.add(realPoint);
        }
        return pointList;
    }

    public static List<TextCodePoint> calTextPoint(List<TextCode> textCodes) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<TextCodePoint> textCodePointList = new ArrayList<TextCodePoint>();
        for (TextCode textCode : textCodes) {
            x = textCode.getX();
            y = textCode.getY();
            Double[] deltaXList = null;
            Double[] deltaYList = null;
            if (textCode.getDeltaX() != null && textCode.getDeltaX().getArray().size() > 0) {
                deltaXList = textCode.getDeltaX().toDouble();
            }
            if (textCode.getDeltaY() != null && textCode.getDeltaY().getArray().size() > 0) {
                deltaYList = textCode.getDeltaY().toDouble();
            }
            for (int i = 0; i < textCode.getText().length(); ++i) {
                if (i > 0 && Objects.nonNull(deltaXList)) {
                    x += deltaXList[i - 1].doubleValue();
                }
                if (i > 0 && Objects.nonNull(deltaYList)) {
                    y += deltaYList[i - 1].doubleValue();
                }
                String text = textCode.getText().substring(i, i + 1);
                TextCodePoint textCodePoint = new TextCodePoint(CommonUtil.converterDpi(x), CommonUtil.converterDpi(y), text);
                textCodePointList.add(textCodePoint);
            }
        }
        return textCodePointList;
    }

    public static double[] adjustPos(double width, double height, double x, double y, ST_Box boundary) {
        double realX = boundary.getTopLeftX() + x;
        double realY = boundary.getTopLeftY() + y;
        return new double[]{realX, realY};
    }

    public static double[] ctmCalPoint(double x, double y, Double[] ctm) {
        double ctmX = x * ctm[0] + y * ctm[2] + 1.0 * ctm[4];
        double ctmY = x * ctm[1] + y * ctm[3] + 1.0 * ctm[5];
        return new double[]{ctmX, ctmY};
    }

    public static List<PathPoint> calPdfPathPoint(double width, double height, ST_Box boundary, List<PathPoint> abbreviatedPoint, boolean hasCtm, ST_Array ctm, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM, boolean fixOriginToPdf) {
        ArrayList<PathPoint> pointList = new ArrayList<PathPoint>();
        for (PathPoint point : abbreviatedPoint) {
            double y1;
            double x1;
            if (point.type.equals("M") || point.type.equals("L") || point.type.equals("C") || point.type.equals("S")) {
                double x = 0.0;
                double y = 0.0;
                x = point.x1;
                y = point.y1;
                if (hasCtm) {
                    double[] newPoint = PointUtil.ctmCalPoint(x, y, ctm.toDouble());
                    x = newPoint[0];
                    y = newPoint[1];
                }
                double[] realPos = PointUtil.adjustPos(width, height, x, y, boundary);
                point.x1 = (float)CommonUtil.converterDpi(realPos[0]);
                point.y1 = (float)CommonUtil.converterDpi(fixOriginToPdf ? height - realPos[1] : realPos[1]);
                if (compositeObjectBoundary != null) {
                    if (compositeObjectCTM != null) {
                        realPos = PointUtil.ctmCalPoint(realPos[0], realPos[1], compositeObjectCTM.toDouble());
                    }
                    realPos = PointUtil.adjustPos(width, height, realPos[0], realPos[1], compositeObjectBoundary);
                    point.x1 = (float)CommonUtil.converterDpi(realPos[0]);
                    point.y1 = (float)CommonUtil.converterDpi(fixOriginToPdf ? height - realPos[1] : realPos[1]);
                }
                pointList.add(point);
                continue;
            }
            if (point.type.equals("B")) {
                x1 = point.x1;
                y1 = point.y1;
                double x2 = point.x2;
                double y2 = point.y2;
                double x3 = point.x3;
                double y3 = point.y3;
                if (hasCtm) {
                    double[] newPoint = PointUtil.ctmCalPoint(x1, y1, ctm.toDouble());
                    x1 = newPoint[0];
                    y1 = newPoint[1];
                    newPoint = PointUtil.ctmCalPoint(x2, y2, ctm.toDouble());
                    x2 = newPoint[0];
                    y2 = newPoint[1];
                    newPoint = PointUtil.ctmCalPoint(x3, y3, ctm.toDouble());
                    x3 = newPoint[0];
                    y3 = newPoint[1];
                }
                double[] realPos = PointUtil.adjustPos(width, height, x1, y1, boundary);
                x1 = realPos[0];
                y1 = realPos[1];
                realPos = PointUtil.adjustPos(width, height, x2, y2, boundary);
                x2 = realPos[0];
                y2 = realPos[1];
                realPos = PointUtil.adjustPos(width, height, x3, y3, boundary);
                x3 = realPos[0];
                y3 = realPos[1];
                PathPoint realPoint = new PathPoint("B", (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y1 : y1), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y2 : y2), (float)CommonUtil.converterDpi(x3), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y3 : y3));
                pointList.add(realPoint);
                continue;
            }
            if (point.type.equals("Q")) {
                x1 = point.x1;
                y1 = point.y1;
                double x2 = point.x2;
                double y2 = point.y2;
                if (hasCtm) {
                    double[] newPoint = PointUtil.ctmCalPoint(x1, y1, ctm.toDouble());
                    x1 = newPoint[0];
                    y1 = newPoint[1];
                    newPoint = PointUtil.ctmCalPoint(x2, y2, ctm.toDouble());
                    x2 = newPoint[0];
                    y2 = newPoint[1];
                }
                double[] realPos = PointUtil.adjustPos(width, height, x1, y1, boundary);
                x1 = realPos[0];
                y1 = realPos[1];
                realPos = PointUtil.adjustPos(width, height, x2, y2, boundary);
                x2 = realPos[0];
                y2 = realPos[1];
                PathPoint realPoint = new PathPoint("Q", (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y1 : y1), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y2 : y2), 0.0f, 0.0f);
                pointList.add(realPoint);
                continue;
            }
            if (!point.type.equals("A")) continue;
            double rx = point.rx;
            double ry = point.ry;
            float rotation = point.rotation;
            float arc = point.arc;
            float sweep = point.sweep;
            double x = point.x;
            double y = point.y;
            if (hasCtm) {
                double[] newPoint = PointUtil.ctmCalPoint(x, y, ctm.toDouble());
                x = newPoint[0];
                y = newPoint[1];
            }
            double[] realPos = PointUtil.adjustPos(width, height, x, y, boundary);
            x = realPos[0];
            y = realPos[1];
            PathPoint realPoint = new PathPoint("A", (float)CommonUtil.converterDpi(rx), (float)CommonUtil.converterDpi(ry), rotation, arc, sweep, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(fixOriginToPdf ? height - y : y));
            pointList.add(realPoint);
        }
        return pointList;
    }

    public static List<TextCodePoint> calPdfTextCoordinate(double width, double height, ST_Box boundary, float fontSize, List<TextCode> textCodes, boolean hasCtm, ST_Array ctm, boolean fixOriginToPdf) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<TextCodePoint> textCodePointList = new ArrayList<TextCodePoint>();
        for (TextCode textCode : textCodes) {
            x = textCode.getX() == null ? 0.0 : textCode.getX();
            double d = y = textCode.getY() == null ? 0.0 : textCode.getY();
            if (hasCtm) {
                double[] newPoint = PointUtil.ctmCalPoint(x, y, ctm.toDouble());
                x = newPoint[0];
                y = newPoint[1];
            }
            List deltaXList = null;
            List deltaYList = null;
            String textStr = textCode.getText();
            if (textCode.getDeltaX() != null && textCode.getDeltaX().getArray().size() > 0) {
                deltaXList = DeltaTool.getDelta((ST_Array)textCode.getDeltaX(), (int)textStr.length());
            }
            if (textCode.getDeltaY() != null && textCode.getDeltaY().getArray().size() > 0) {
                deltaYList = DeltaTool.getDelta((ST_Array)textCode.getDeltaY(), (int)textStr.length());
            }
            textStr = textStr.replaceAll("&lt;", "<");
            textStr = textStr.replaceAll("&gt;", ">");
            textStr = textStr.replaceAll("&amp;", "&");
            textStr = textStr.replaceAll("\n", "");
            textStr = textStr.replaceAll("&nbsp;", " ");
            textStr = textStr.replaceAll("&quot;", "\"");
            textStr = textStr.replaceAll("&copy;", "");
            textStr = textStr.replaceAll("&apos;", "'");
            for (int i = 0; i < textStr.length(); ++i) {
                double[] newPoint;
                double angel;
                double f;
                double e;
                double d2;
                double c;
                double b;
                double a;
                Double[] ctms;
                float decent = 0.0f;
                if (i > 0 && Objects.nonNull(deltaXList)) {
                    if (hasCtm) {
                        ctms = ctm.toDouble();
                        a = ctms[0];
                        b = ctms[1];
                        c = ctms[2];
                        d2 = ctms[3];
                        e = ctms[4];
                        f = ctms[5];
                        angel = Math.atan2(-b, d2);
                        if (angel == 0.0) {
                            newPoint = PointUtil.ctmCalPoint(((Float)deltaXList.get(i - 1)).floatValue(), 0.0, ctm.toDouble());
                            x += newPoint[0];
                        } else {
                            x += (double)((Float)deltaXList.get(i - 1)).floatValue();
                        }
                    } else {
                        x += (double)((Float)deltaXList.get(i - 1)).floatValue();
                    }
                }
                if (i > 0 && Objects.nonNull(deltaYList)) {
                    if (hasCtm) {
                        ctms = ctm.toDouble();
                        a = ctms[0];
                        b = ctms[1];
                        c = ctms[2];
                        d2 = ctms[3];
                        e = ctms[4];
                        f = ctms[5];
                        angel = Math.atan2(-b, d2);
                        if (angel == 0.0) {
                            newPoint = PointUtil.ctmCalPoint(0.0, ((Float)deltaYList.get(i - 1)).floatValue(), ctm.toDouble());
                            y += newPoint[1];
                        } else {
                            y += (double)((Float)deltaYList.get(i - 1)).floatValue();
                        }
                    } else {
                        y += (double)((Float)deltaYList.get(i - 1)).floatValue();
                    }
                }
                double[] realPos = PointUtil.adjustPos(width, height, x, y, boundary);
                String text = textStr.substring(i, i + 1);
                TextCodePoint textCodePoint = new TextCodePoint(CommonUtil.converterDpi(realPos[0]), CommonUtil.converterDpi(fixOriginToPdf ? height - realPos[1] : realPos[1]), text);
                textCodePointList.add(textCodePoint);
            }
        }
        return textCodePointList;
    }
}

