/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.objenesis.tck.Candidate;

public abstract class AbstractLoader {
    private final ClassLoader classloader;
    private final ErrorHandler errorHandler;

    public AbstractLoader(ClassLoader classloader, ErrorHandler errorHandler) {
        this.classloader = classloader;
        this.errorHandler = errorHandler;
    }

    public void loadFrom(InputStream inputStream, final Candidate.CandidateType type) throws IOException {
        Properties properties = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object put(Object key, Object value) {
                AbstractLoader.this.handlePropertyEntry((String)key, (String)value, type);
                return null;
            }
        };
        properties.load(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromResource(String resource, Candidate.CandidateType type) throws IOException {
        InputStream candidatesConfig = this.classloader.getResourceAsStream(resource);
        if (candidatesConfig == null) {
            throw new IOException("Resource '" + resource + "' not found");
        }
        try {
            this.loadFrom(candidatesConfig, type);
        }
        finally {
            candidatesConfig.close();
        }
    }

    private void handlePropertyEntry(String key, String value, Candidate.CandidateType type) {
        try {
            Class<?> candidate = Class.forName(key, true, this.classloader);
            this.handlePropertyEntry(candidate, value, type);
        }
        catch (ClassNotFoundException e) {
            this.errorHandler.classNotFound(key);
        }
    }

    protected abstract void handlePropertyEntry(Class<?> var1, String var2, Candidate.CandidateType var3);

    public static class LoggingErrorHandler
    implements ErrorHandler {
        private final PrintStream out;

        public LoggingErrorHandler(PrintStream out) {
            this.out = out;
        }

        @Override
        public void classNotFound(String name) {
            this.out.println("Class not found : " + name);
        }
    }

    public static interface ErrorHandler {
        public void classNotFound(String var1);
    }
}

