/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.util;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;

public class SimpleRuntime
extends AbstractRuntimeService {
    private static final Log log = LogFactory.getLog(SimpleRuntime.class);
    public static final String NAME = "Simple Runtime";
    public static final Version VERSION = Version.parseString("1.0.0");
    static int counter = 0;

    public SimpleRuntime() {
        this((File)null);
        try {
            this.workingDir = File.createTempFile("NXTestFramework", SimpleRuntime.generateId());
            this.workingDir.delete();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public SimpleRuntime(String home) {
        this(new File(home));
    }

    public SimpleRuntime(File workingDir) {
        super(new DefaultRuntimeContext());
        this.workingDir = workingDir;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    private static synchronized String generateId() {
        long stamp = System.currentTimeMillis();
        return Long.toHexString(stamp) + '-' + System.identityHashCode(System.class) + '.' + ++counter;
    }

    public void deploy(URL url) throws Exception {
        this.context.deploy(url);
    }

    public void undeploy(URL url) throws Exception {
        this.context.undeploy(url);
    }

    @Override
    public void reloadProperties() throws Exception {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

