/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.nuxeo.runtime.model.persistence.AbstractContribution;
import org.nuxeo.runtime.model.persistence.fs.FileSystemStorage;

public class ContributionFile
extends AbstractContribution {
    protected String name;
    protected String description;
    protected boolean disabled;
    protected boolean loaded;
    protected File file;

    public ContributionFile(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void load() {
        if (!this.loaded) {
            FileSystemStorage.loadMetadata(this);
            this.loaded = true;
        }
    }

    @Override
    public String getDescription() {
        this.load();
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isDisabled() {
        this.load();
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.disabled = isDisabled;
    }

    @Override
    public URL asURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getContent() {
        try {
            return FileSystemStorage.safeRead(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get contribution content: " + this.name);
        }
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.getContent().getBytes());
    }
}

