/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config;

import java.util.ArrayList;
import java.util.List;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.config.ConfigurationException;
import org.nuxeo.runtime.config.ServerConfiguration;
import org.nuxeo.runtime.remoting.Server;
import org.nuxeo.runtime.remoting.UnsupportedServerVersionException;

public abstract class ConfigurationHandler {
    private static final List<ConfigurationHandler> registry = new ArrayList<ConfigurationHandler>();

    public static void registerHandler(ConfigurationHandler handler) {
        registry.add(handler);
    }

    public static ConfigurationHandler getHandler(Version version) throws UnsupportedServerVersionException {
        if (version == null) {
            version = Version.MIN;
        }
        int len = registry.size();
        for (int i = 0; i < len; ++i) {
            ConfigurationHandler cl = registry.get(i);
            if (!cl.accept(version)) continue;
            return cl;
        }
        throw new UnsupportedServerVersionException(version);
    }

    public static ServerConfiguration loadConfig(InvokerLocator locator, Server server, String version) throws ConfigurationException {
        return ConfigurationHandler.loadConfig(locator, server, Version.parseString(version));
    }

    public static ServerConfiguration loadConfig(InvokerLocator locator, Server server, Version version) throws ConfigurationException {
        return ConfigurationHandler.getHandler(version).loadConfig(locator, server);
    }

    public static ServerConfiguration buildConfig(Version version) throws ConfigurationException {
        return ConfigurationHandler.getHandler(version).buildConfig();
    }

    public boolean accept(Version v) {
        return v.isEqualTo(this.getVersion());
    }

    public abstract Version getVersion();

    public abstract ServerConfiguration loadConfig(InvokerLocator var1, Server var2) throws ConfigurationException;

    public abstract ServerConfiguration buildConfig() throws ConfigurationException;
}

