/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.login.DefaultCallbackHandler;
import org.nuxeo.runtime.api.login.LoginModuleDescriptor;

@XObject(value="domain")
public class SecurityDomain
implements Serializable {
    private static final long serialVersionUID = 5770889355854831093L;
    @XNode(value="@name")
    private String name;
    private transient AppConfigurationEntry[] entries;

    public SecurityDomain() {
    }

    public SecurityDomain(String name) {
        this.name = name;
    }

    public SecurityDomain(String name, AppConfigurationEntry[] entries) {
        this.name = name;
        this.entries = entries;
    }

    public String getName() {
        return this.name;
    }

    public AppConfigurationEntry[] getAppConfigurationEntries() {
        return this.entries;
    }

    public void setAppConfigurationEntries(AppConfigurationEntry[] entries) {
        this.entries = entries;
    }

    @XNodeList(value="login-module", type=ArrayList.class, componentType=LoginModuleDescriptor.class)
    public void setEntries(List<LoginModuleDescriptor> descriptors) {
        this.entries = new AppConfigurationEntry[descriptors.size()];
        int i = 0;
        for (LoginModuleDescriptor descriptor : descriptors) {
            AppConfigurationEntry.LoginModuleControlFlag flag = null;
            if (descriptor.flag == null) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else if ("optional".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else if ("sufficient".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if ("required".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if ("requisite".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
            this.entries[i++] = new AppConfigurationEntry(descriptor.code, flag, descriptor.options);
        }
    }

    public LoginContext login(Subject subject) throws LoginException {
        LoginContext ctx = new LoginContext(this.name, subject);
        ctx.login();
        return ctx;
    }

    public LoginContext login(CallbackHandler handler) throws LoginException {
        LoginContext ctx = new LoginContext(this.name, handler);
        ctx.login();
        return ctx;
    }

    public LoginContext login(Subject subject, CallbackHandler handler) throws LoginException {
        LoginContext ctx = new LoginContext(this.name, subject, handler);
        ctx.login();
        return ctx;
    }

    public LoginContext login(String username, Object credentials) throws LoginException {
        DefaultCallbackHandler handler = new DefaultCallbackHandler(username, credentials);
        LoginContext ctx = new LoginContext(this.name, handler);
        ctx.login();
        return ctx;
    }

    public static String controlFlagToString(AppConfigurationEntry.LoginModuleControlFlag flag) {
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
            return "optional";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
            return "required";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
            return "requisite";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
            return "sufficient";
        }
        throw new IllegalArgumentException("Not a supported LoginModuleControlFlag: " + flag);
    }

    public static AppConfigurationEntry.LoginModuleControlFlag controlFlagFromString(String flag) {
        if (flag == null) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("optional".equals(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("sufficient".equals(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("required".equals(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("requisite".equals(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        throw new IllegalArgumentException("Not a supported LoginModuleControlFlag: " + flag);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        int size = in.readInt();
        this.entries = new AppConfigurationEntry[size];
        for (int i = 0; i < size; ++i) {
            String name = (String)in.readObject();
            String ctrlFlag = (String)in.readObject();
            AppConfigurationEntry.LoginModuleControlFlag flag = SecurityDomain.controlFlagFromString(ctrlFlag);
            Map opts = (Map)in.readObject();
            this.entries[i] = new AppConfigurationEntry(name, flag, opts);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.entries == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.entries.length);
            for (AppConfigurationEntry entry : this.entries) {
                out.writeObject(entry.getLoginModuleName());
                out.writeObject(SecurityDomain.controlFlagToString(entry.getControlFlag()));
                Map<String, ?> opts = entry.getOptions();
                if (!(opts instanceof Serializable)) {
                    opts = new HashMap(opts);
                }
                out.writeObject(opts);
            }
        }
    }
}

