/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.deployment;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.nuxeo.runtime.services.deployment.DeploymentDescriptor;
import org.osgi.framework.Bundle;

public class DeploymentService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.services.deployment.DeploymentService");
    private static final Log log = LogFactory.getLog(DeploymentService.class);
    private Map<String, DeploymentDescriptor> deployments;

    public void activate(ComponentContext context) {
        this.deployments = new Hashtable<String, DeploymentDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.deployments.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("deployments")) {
            File root = null;
            DeploymentDescriptor deployment = (DeploymentDescriptor)contribution;
            this.deployments.put(deployment.src, deployment);
            RuntimeContext ctx = contributor.getContext();
            if (ctx instanceof OSGiRuntimeContext) {
                Bundle bundle = ((OSGiRuntimeContext)ctx).getBundle();
                String location = bundle.getLocation();
                try {
                    root = new File(new URI(location));
                    if (root.isFile()) {
                        root = root.getParentFile();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed to locate bundle at " + location));
                }
                File srcFile = new File(root, deployment.src);
                File[] files = srcFile.isDirectory() ? srcFile.listFiles() : new File[]{srcFile};
                for (File file : files) {
                    try {
                        URL url = file.toURL();
                        log.info((Object)("Deploying external component: " + url));
                        deployment.urls = new ArrayList<URL>();
                        ctx.deploy(url);
                        deployment.urls.add(url);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to deploy: " + file), (Throwable)e);
                    }
                }
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("deployments")) {
            DeploymentDescriptor provider = (DeploymentDescriptor)contribution;
            provider = this.deployments.get(provider.src);
            if (provider != null) {
                if (provider.urls != null) {
                    for (URL url : provider.urls) {
                        try {
                            log.info((Object)("Undeploying external component: " + url));
                            contributor.getContext().undeploy(url);
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to undeploy: " + url), (Throwable)e);
                        }
                    }
                }
            } else {
                log.warn((Object)("Unregistering unknown provider: " + ((DeploymentDescriptor)contribution).src));
            }
        }
    }
}

