/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting.net.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.net.EventHandler;
import org.nuxeo.runtime.remoting.net.NetworkNode;
import org.nuxeo.runtime.remoting.net.NodeInfo;
import org.nuxeo.runtime.remoting.net.impl.NetworkPeer;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;
import org.nuxeo.runtime.remoting.transporter.TransporterServer;

public class NetworkNodeImpl
implements NetworkNode,
NetworkPeer {
    private static final Log log = LogFactory.getLog(NetworkNodeImpl.class);
    private static final Object lock = new Object();
    private final Map<String, PeerEntry> detectedNodes = new HashMap<String, PeerEntry>();
    private final Map<String, PeerEntry> peers = new HashMap<String, PeerEntry>();
    private final NodeInfo info;
    private EventHandler handler;

    public NetworkNodeImpl(RemotingService remoting, NodeInfo info) throws Exception {
        this.info = info;
        TransporterServer transporterServer = remoting.getTransporterServer();
        transporterServer.addHandler(this, NetworkPeer.class.getName());
    }

    public void connect(String group) throws Exception {
        if (group == null || group.equals(this.info.uri)) {
            log.info((Object)"Ignore connecting to the network group -> I am the group master");
            return;
        }
        log.info((Object)("Connecting to the network group: " + group));
        PeerEntry entry = this.nodeAdded(group);
        if (entry == null) {
            return;
        }
        NodeInfo[] infos = entry.peer.getPeers();
        if (infos == null) {
            return;
        }
        for (NodeInfo nodeInfo : infos) {
            if (nodeInfo.uri.equals(this.info.uri)) continue;
            this.nodeAdded(nodeInfo.uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        log.info((Object)"Disconnecting from network group");
        Iterator<PeerEntry> it = this.peers.values().iterator();
        while (it.hasNext()) {
            PeerEntry entry = it.next();
            try {
                entry.peer.close(this.info.uri);
            }
            catch (Exception e) {
                log.error((Object)("Failed to send nodeRemoved event to peer: " + entry.info));
            }
            finally {
                TransporterClient.destroyTransporterClient(entry.peer);
            }
            it.remove();
        }
        this.peers.clear();
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public NodeInfo getNodeInfo() {
        return this.info;
    }

    public String getNodeURI() {
        return this.info.uri;
    }

    public NodeInfo[] getPeers() {
        ArrayList<NodeInfo> infos = new ArrayList<NodeInfo>(this.peers.size());
        for (PeerEntry peer : this.peers.values()) {
            infos.add(peer.info);
        }
        return infos.toArray(new NodeInfo[infos.size()]);
    }

    public void send(Serializable event) throws Exception {
        PeerEntry[] entries = this.peers.values().toArray(new PeerEntry[this.peers.size()]);
        if (entries == null) {
            return;
        }
        for (PeerEntry entry : entries) {
            try {
                entry.peer.handleEvent(this.info.uri, event);
            }
            catch (Exception e) {
                log.error((Object)("Failed to send event " + event + " to peer: " + entry.info));
            }
        }
    }

    public void sendTo(String uri, Serializable event) throws Exception {
        PeerEntry entry = this.peers.get(uri);
        if (entry == null) {
            return;
        }
        try {
            entry.peer.handleEvent(this.info.uri, event);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send event " + event + " to peer: " + entry.info));
        }
    }

    public void setEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    public void handleEvent(String source, Serializable event) throws Exception {
        if (this.handler != null) {
            this.handler.handleEvent(source, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected(String uri) {
        Object object = lock;
        synchronized (object) {
            return this.peers.containsKey(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syn(NodeInfo info) throws Exception {
        PeerEntry entry;
        log.info((Object)("Received SYN from " + info));
        boolean isNew = false;
        Object object = lock;
        synchronized (object) {
            if (this.peers.containsKey(info.uri)) {
                log.info((Object)"Already connected. Ignoring SYN");
                return;
            }
            entry = this.detectedNodes.remove(info.uri);
            if (entry == null) {
                entry = this.createPeerEntry(info.uri);
                isNew = true;
            } else {
                entry.info = info;
            }
            this.peers.put(info.uri, entry);
        }
        if (isNew) {
            log.info((Object)("Sending SYN to " + info));
            entry.peer.syn(this.info);
        }
        if (this.handler != null) {
            this.handler.peerConnected(info);
        }
    }

    public void close(String uri) {
        this.nodeRemoved(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRemoved(String uri) {
        Object object = lock;
        synchronized (object) {
            PeerEntry entry = this.peers.remove(uri);
            if (entry == null) {
                entry = this.detectedNodes.remove(uri);
            }
            if (entry != null) {
                log.info((Object)("Node removed: " + uri));
                try {
                    if (this.handler != null) {
                        this.handler.peerRemoved(uri);
                    }
                }
                finally {
                    TransporterClient.destroyTransporterClient(entry.peer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerEntry nodeAdded(String uri) {
        log.info((Object)("Detected node: " + uri));
        PeerEntry entry = null;
        try {
            Object object = lock;
            synchronized (object) {
                entry = this.detectedNodes.get(uri);
                if (entry != null) {
                    log.info((Object)"Node already detected. Ignoring.");
                    return entry;
                }
                entry = this.peers.get(uri);
                if (entry != null) {
                    log.info((Object)"Node already detected. Ignoring.");
                    return entry;
                }
                entry = this.createPeerEntry(uri);
                this.detectedNodes.put(uri, entry);
            }
            log.info((Object)("Sending SYN to " + uri));
            entry.peer.syn(this.info);
        }
        catch (Exception e) {
            log.error((Object)"Failed to add peer node", (Throwable)e);
        }
        return entry;
    }

    protected PeerEntry createPeerEntry(String uri) throws Exception {
        return this.createPeerEntry(new NodeInfo(uri));
    }

    protected PeerEntry createPeerEntry(NodeInfo info) throws Exception {
        InvokerLocator locator = new InvokerLocator(info.uri);
        NetworkPeer peer = (NetworkPeer)TransporterClient.createTransporterClient(locator, NetworkPeer.class);
        return new PeerEntry(info, peer);
    }

    static class PeerEntry {
        public NodeInfo info;
        public final NetworkPeer peer;

        public PeerEntry(NodeInfo info, NetworkPeer peer) {
            this.info = info;
            this.peer = peer;
        }
    }
}

