/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting.net;

import java.io.Serializable;

public class NodeInfo
implements Serializable {
    private static final long serialVersionUID = 116405393947110529L;
    public final String uri;
    public String name;
    public String description;

    public NodeInfo(String uri) {
        this(uri, null, null);
    }

    public NodeInfo(String uri, String name) {
        this(uri, name, null);
    }

    public NodeInfo(String uri, String name, String description) {
        this.uri = uri;
        this.name = name;
        this.description = description;
    }

    public String toString() {
        return (this.name == null ? "Node" : this.name) + " <" + this.uri + '>';
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeInfo) {
            NodeInfo info = (NodeInfo)obj;
            if (!this.uri.equals(info.uri)) {
                return false;
            }
            if (this.name != null && !this.name.equals(info.name)) {
                return false;
            }
            return this.description == null || this.description.equals(info.description);
        }
        return false;
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

