/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import java.io.File;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamManagerClient;
import org.nuxeo.runtime.services.streaming.StreamManagerServer;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

public class StreamingFeature
extends SimpleFeature {
    protected StreamManagerClient client;
    protected StreamManagerServer server;
    protected File tmpDir;

    @Override
    public void start(FeaturesRunner runner) throws Exception {
        this.tmpDir = new File(Framework.getRuntime().getHome(), "tmp/uploads");
        this.server = new StreamManagerServer("localhost", 3234, this.tmpDir);
        this.client = new StreamManagerClient("socket://127.0.0.1:3234");
        this.server.start();
    }

    @Override
    public void stop(FeaturesRunner runner) throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.tmpDir.delete();
        this.client = null;
        this.server = null;
        this.tmpDir = null;
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(StreamManager.class).toInstance((Object)this.client);
        binder.bind(StreamManagerServer.class).toInstance((Object)this.server);
        binder.bind(StreamManagerClient.class).toInstance((Object)this.client);
    }
}

