/*
 * (C) Copyright 2006-2014 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.nuxeo.ecm.core.redis;

import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class SingletonContributionRegistry<T> extends SimpleContributionRegistry<T> {

    protected T main;

    @Override
    public String getContributionId(T contrib) {
        return "main";
    }

    @Override
    public void contributionUpdated(String id, T contrib, T newOrigContrib) {
        main = contrib;
    }

    @Override
    public void contributionRemoved(String id, T origContrib) {
        main = null;
    }
}
