/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jetty;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.nuxeo.runtime.jetty.FilterDescriptor;
import org.nuxeo.runtime.jetty.ServletContextListenerDescriptor;
import org.nuxeo.runtime.jetty.ServletDescriptor;

public class ContextManager {
    protected Log log = LogFactory.getLog(ContextManager.class);
    protected Server server;
    protected Map<String, Context> contexts;
    protected Map<String, ServletContextListenerDescriptor> listeners;

    public ContextManager(Server server) {
        this.server = server;
        this.contexts = new HashMap<String, Context>();
        this.listeners = new HashMap<String, ServletContextListenerDescriptor>();
    }

    public Server getServer() {
        return this.server;
    }

    public synchronized void addFilter(FilterDescriptor descriptor) {
        Map<String, String> params;
        String desc;
        String path = descriptor.getContext();
        Context ctx = this.contexts.get(path);
        if (ctx == null) {
            ctx = new Context((HandlerContainer)this.server, path, 1);
            this.contexts.put(path, ctx);
        }
        FilterHolder holder = new FilterHolder(descriptor.getClazz());
        String name = descriptor.getName();
        if (name != null) {
            holder.setName(name);
        }
        if ((desc = descriptor.getDescription()) != null) {
            holder.setDisplayName(desc);
        }
        if ((params = descriptor.getInitParams()) != null) {
            holder.setInitParameters(params);
        }
        ctx.addFilter(holder, descriptor.getPath(), 0);
    }

    public synchronized void addServlet(ServletDescriptor descriptor) {
        Map<String, String> params;
        String desc;
        String path = descriptor.getContext();
        Context ctx = this.contexts.get(path);
        if (ctx == null) {
            ctx = new Context((HandlerContainer)this.server, path, 1);
            this.contexts.put(path, ctx);
        }
        ServletHolder holder = new ServletHolder(descriptor.getClazz());
        String name = descriptor.getName();
        if (name != null) {
            holder.setName(name);
        }
        if ((desc = descriptor.getDescription()) != null) {
            holder.setDisplayName(desc);
        }
        if ((params = descriptor.getInitParams()) != null) {
            holder.setInitParameters(params);
        }
        ctx.addServlet(holder, descriptor.getPath());
    }

    public synchronized void addLifecycleListener(ServletContextListenerDescriptor descriptor) {
        this.listeners.put(descriptor.name, descriptor);
    }

    public synchronized void removeLifecycleListener(ServletContextListenerDescriptor descriptor) {
        this.listeners.remove(descriptor.name);
    }

    public synchronized void removeFilter(FilterDescriptor descriptor) {
    }

    public synchronized void removeServlet(ServletDescriptor descriptor) {
    }

    public void applyLifecycleListeners() {
        HandlerCollection hc = (HandlerCollection)this.server.getHandler();
        Handler[] handlers = hc.getChildHandlersByClass(WebAppContext.class);
        for (ServletContextListenerDescriptor desc : this.listeners.values()) {
            ServletContextListener listener;
            try {
                listener = desc.clazz.newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)("Cannot add life cycle listener " + desc.name), (Throwable)e);
                continue;
            }
            for (Handler handler : handlers) {
                WebAppContext context = (WebAppContext)handler;
                if (!context.getContextPath().matches(desc.context)) continue;
                context.addEventListener((EventListener)listener);
            }
        }
    }
}

