/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.deployment.preprocessor.ConfigurationGenerator;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackZip {
    protected File nuxeoEar;
    protected File deployerJar;
    protected File deployDir;
    protected File jbossLib;
    protected File dsFile;
    protected File target;

    public PackZip(File nuxeoEar, File target) {
        if (!nuxeoEar.isDirectory()) {
            throw new IllegalArgumentException("Invalid build - no exploded nuxeo.ear found at " + nuxeoEar.getAbsolutePath());
        }
        if (!target.isDirectory()) {
            throw new IllegalArgumentException("Invalid configuration - no target directory found at " + nuxeoEar.getAbsolutePath());
        }
        this.nuxeoEar = nuxeoEar;
        this.target = target;
        this.deployDir = nuxeoEar.getParentFile();
        this.jbossLib = new File(this.deployDir.getParentFile(), "lib");
        this.dsFile = new File(this.deployDir, "nuxeo-ds.xml");
        File deployers = new File(this.deployDir.getParentFile(), "deployers");
        String[] names = deployers.list();
        if (names == null) {
            throw new IllegalArgumentException("Invalid nuxeo.ear location - no nuxeo jboss deployer JAR found in deployers directory");
        }
        for (String name : names) {
            if (!name.startsWith("nuxeo-jboss-deployer") || !name.endsWith(".jar")) continue;
            this.deployerJar = new File(deployers, name);
        }
        if (this.deployerJar == null) {
            throw new IllegalArgumentException("Invalid build - no nuxeo jboss deployer JAR found in deployers directory");
        }
    }

    public void execute() throws Exception {
        new ConfigurationGenerator().run();
        this.runPreprocessor();
        this.moveNonEjbsToLib(this.nuxeoEar);
        this.replaceStructureFile();
        this.moveJarsFromJbossLib();
        this.deployerJar.renameTo(new File(this.nuxeoEar, "lib/" + this.deployerJar.getName()));
        ZipUtils.zip((File[])this.nuxeoEar.listFiles(), (File)new File(this.target, "nuxeo.ear"));
        FileUtils.copy((File)this.dsFile, (File)this.target);
    }

    protected void runPreprocessor() {
        System.setProperty("org.nuxeo.runtme.preprocessing.jboss5", "true");
        DeploymentPreprocessor.main(new String[]{this.nuxeoEar.getAbsolutePath()});
    }

    protected void replaceStructureFile() {
        File oldf = new File(this.nuxeoEar, "META-INF/nuxeo-structure.xml");
        File newf = new File(this.nuxeoEar, "META-INF/nuxeo-structure-zip.xml");
        newf.renameTo(oldf);
    }

    protected void moveJarsFromJbossLib() {
    }

    protected void moveNonEjbsToLib(File wd) throws Exception {
        File file = new File(wd, "META-INF/application.xml");
        if (!file.isFile()) {
            System.err.println("You should run this tool from a preprocessed nuxeo.ear folder");
        }
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        FileInputStream in = new FileInputStream(file);
        Document doc = docBuilder.parse(in);
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("module");
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            for (Node n = el.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                Element mtype = (Element)n;
                String type = n.getNodeName().toLowerCase();
                String path = null;
                if ("web".equals(type)) continue;
                path = mtype.getTextContent().trim();
                paths.add(path);
            }
        }
        File ejbs = new File(wd, "tmp-ejbs");
        ejbs.mkdirs();
        for (String path : paths) {
            System.out.println("Move EAR module " + path + " to " + ejbs.getName());
            File f = new File(wd, path);
            f.renameTo(new File(ejbs, f.getName()));
        }
        File lib = new File(wd, "lib");
        File[] files = new File(wd, "bundles").listFiles();
        if (files != null) {
            for (File f : files) {
                System.out.println("Move POJO bundle " + f.getName() + " to lib");
                f.renameTo(new File(lib, f.getName()));
            }
        }
        File bundles = new File(wd, "bundles");
        files = ejbs.listFiles();
        if (files != null) {
            for (File f : files) {
                System.out.println("Move back EAR module " + f.getName() + " to bundles");
                f.renameTo(new File(bundles, f.getName()));
            }
        }
    }

    protected static void fail(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        String v;
        File ear;
        if (args.length != 2) {
            PackZip.fail("Usage: PackZip nuxeo_ear_directory target_directory");
            System.err.println();
        }
        File file = ear = (v = args[0]).startsWith("/") ? new File(v) : new File(".", v);
        if (!ear.isDirectory()) {
            PackZip.fail("Invalid build - no exploded nuxeo.ear found at " + ear.getAbsolutePath());
        }
        File target = (v = args[1]).startsWith("/") ? new File(v) : new File(".", v);
        ear = ear.getCanonicalFile();
        if ((target = target.getCanonicalFile()).exists()) {
            FileUtils.deleteTree((File)target);
        }
        target.mkdirs();
        if (!target.isDirectory()) {
            PackZip.fail("Invalid target directory: " + v + ". Not a directory or directory could not be created");
        }
        System.out.println("Packing nuxeo.ear at " + ear.getAbsolutePath() + " into " + target.getAbsolutePath());
        new PackZip(ear, target).execute();
    }
}

