/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.info;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.info.MessageInfo;
import org.nuxeo.launcher.info.PackageInfo;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="command")
public class CommandInfo {
    static final Log log = LogFactory.getLog(CommandInfo.class);
    public static final String CMD_UNKNOWN = "unknown";
    public static final String CMD_LIST = "list";
    public static final String CMD_ADD = "add";
    public static final String CMD_INSTALL = "install";
    public static final String CMD_UNINSTALL = "uninstall";
    public static final String CMD_REMOVE = "remove";
    public static final String CMD_RESET = "reset";
    public static final String CMD_DOWNLOAD = "download";
    public static final String CMD_INIT = "init";
    public static final String CMD_SHOW = "show";
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String param;
    @XmlAttribute
    public Integer exitCode = 0;
    @XmlAttribute
    public String id;
    @XmlAttribute
    public boolean pending = false;
    @XmlElementWrapper(name="messages")
    @XmlElement(name="message")
    public List<MessageInfo> messages = new ArrayList<MessageInfo>();
    @XmlElementWrapper(name="packages")
    @XmlElement(name="package")
    public List<PackageInfo> packages = new ArrayList<PackageInfo>();

    public CommandInfo() {
    }

    public CommandInfo(String cmdType) {
        this.name = cmdType;
    }

    public MessageInfo newMessage() {
        MessageInfo messageInfo = new MessageInfo();
        this.messages.add(messageInfo);
        return messageInfo;
    }

    public MessageInfo newMessage(int level, String message) {
        MessageInfo messageInfo = new MessageInfo(level, message);
        this.messages.add(messageInfo);
        return messageInfo;
    }

    public MessageInfo newMessage(Exception e) {
        return this.newMessage(5, e);
    }

    public MessageInfo newMessage(int level, Exception e) {
        log.debug((Object)e, (Throwable)e);
        return this.newMessage(level, e.getMessage());
    }

    public void log(boolean debug) {
        StringBuilder sb = new StringBuilder();
        if (this.pending) {
            sb.append("* Pending action: " + this.name);
        } else {
            sb.append("* " + this.name);
        }
        if (this.id != null) {
            sb.append(" [" + this.id + "]");
        }
        if (this.param != null) {
            sb.append(" (" + this.param + ")");
        }
        for (PackageInfo packageInfo : this.packages) {
            sb.append("\n\t" + new ReflectionToStringBuilder((Object)packageInfo, ToStringStyle.SHORT_PREFIX_STYLE).setExcludeFieldNames(new String[]{"description"}).toString());
        }
        if (this.exitCode != 0 || debug) {
            if (this.exitCode != 0) {
                log.error((Object)sb.toString());
            } else {
                log.info((Object)sb.toString());
            }
            for (MessageInfo messageInfo : this.messages) {
                messageInfo.log();
            }
        }
    }
}

