/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.InputStream;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDrivePermission;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.OneDriveThumbnail;
import org.nuxeo.onedrive.client.OneDriveThumbnailSet;
import org.nuxeo.onedrive.client.OneDriveThumbnailSetIterator;
import org.nuxeo.onedrive.client.OneDriveThumbnailSize;
import org.nuxeo.onedrive.client.URLTemplate;

public abstract class OneDriveItem
extends OneDriveResource {
    private static final URLTemplate CREATE_SHARED_LINK_URL = new URLTemplate("/drive/items/%s/action.createLink");
    private static final URLTemplate CREATE_SHARED_LINK_ROOT_URL = new URLTemplate("/drive/root/action.createLink");

    OneDriveItem(OneDriveAPI api) {
        super(api);
    }

    public OneDriveItem(OneDriveAPI api, String id) {
        super(api, id);
    }

    public abstract Metadata getMetadata(OneDriveExpand ... var1) throws OneDriveAPIException;

    public OneDriveThumbnailSet.Metadata getThumbnailSet() throws OneDriveAPIException {
        try {
            Iterator<OneDriveThumbnailSet.Metadata> iterator = this.getThumbnailSets().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (OneDriveRuntimeException e) {
            throw new OneDriveAPIException(e.getMessage(), e);
        }
        return null;
    }

    public OneDriveThumbnail.Metadata getThumbnail(OneDriveThumbnailSize size) throws OneDriveAPIException {
        return new OneDriveThumbnail(this.getApi(), this.getId(), size).getMetadata();
    }

    public InputStream downloadThumbnail(OneDriveThumbnailSize size) throws OneDriveAPIException {
        return new OneDriveThumbnail(this.getApi(), this.getId(), size).download();
    }

    Iterable<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
        return () -> new OneDriveThumbnailSetIterator(this.getApi(), this.getId());
    }

    public OneDrivePermission.Metadata createSharedLink(OneDriveSharingLink.Type type) throws OneDriveAPIException {
        URL url = this.isRoot() ? CREATE_SHARED_LINK_ROOT_URL.build(this.getApi().getBaseURL(), new Object[0]) : CREATE_SHARED_LINK_URL.build(this.getApi().getBaseURL(), this.getId());
        OneDriveJsonRequest request = new OneDriveJsonRequest(this.getApi(), url, "POST");
        request.setBody(new JsonObject().add("type", type.getType()));
        OneDriveJsonResponse response = (OneDriveJsonResponse)request.send();
        String permissionId = response.getContent().asObject().get("id").asString();
        OneDrivePermission permission = this.isRoot() ? new OneDrivePermission(this.getApi(), permissionId) : new OneDrivePermission(this.getApi(), this.getId(), permissionId);
        OneDrivePermission oneDrivePermission = permission;
        oneDrivePermission.getClass();
        return oneDrivePermission.new OneDrivePermission.Metadata(response.getContent());
    }

    public abstract class Metadata
    extends OneDriveResource.Metadata {
        private String name;
        private String eTag;
        private OneDriveIdentitySet createdBy;
        private ZonedDateTime createdDateTime;
        private OneDriveIdentitySet lastModifiedBy;
        private ZonedDateTime lastModifiedDateTime;
        private long size;
        private OneDriveFolder.Reference parentReference;
        private String webUrl;
        private String description;
        private boolean deleted;
        private List<OneDriveThumbnailSet.Metadata> thumbnailSets;

        public Metadata(JsonObject json) {
            super(json);
            this.thumbnailSets = Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public String getETag() {
            return this.eTag;
        }

        public OneDriveIdentitySet getCreatedBy() {
            return this.createdBy;
        }

        public ZonedDateTime getCreatedDateTime() {
            return this.createdDateTime;
        }

        public OneDriveIdentitySet getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public ZonedDateTime getLastModifiedDateTime() {
            return this.lastModifiedDateTime;
        }

        public long getSize() {
            return this.size;
        }

        public OneDriveFolder.Reference getParentReference() {
            return this.parentReference;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public OneDriveThumbnailSet.Metadata getThumbnailSet() {
            return this.thumbnailSets.stream().findFirst().orElse(null);
        }

        List<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
            return Collections.unmodifiableList(this.thumbnailSets);
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("name".equals(memberName)) {
                    this.name = value.asString();
                } else if ("eTag".equals(memberName)) {
                    this.eTag = value.asString();
                } else if ("createdBy".equals(memberName)) {
                    this.createdBy = new OneDriveIdentitySet(value.asObject());
                } else if ("createdDateTime".equals(memberName)) {
                    this.createdDateTime = ZonedDateTime.parse(value.asString());
                } else if ("lastModifiedBy".equals(memberName)) {
                    this.lastModifiedBy = new OneDriveIdentitySet(value.asObject());
                } else if ("lastModifiedDateTime".equals(memberName)) {
                    this.lastModifiedDateTime = ZonedDateTime.parse(value.asString());
                } else if ("size".equals(memberName)) {
                    this.size = value.asLong();
                } else if ("parentReference".equals(memberName)) {
                    OneDriveFolder parentFolder;
                    JsonObject valueObject = value.asObject();
                    String id = valueObject.get("id").asString();
                    OneDriveFolder oneDriveFolder = parentFolder = new OneDriveFolder(OneDriveItem.this.getApi(), id);
                    oneDriveFolder.getClass();
                    this.parentReference = new OneDriveFolder.Reference(oneDriveFolder, valueObject);
                } else if ("webUrl".equals(memberName)) {
                    this.webUrl = value.asString();
                } else if ("description".equals(memberName)) {
                    this.description = value.asString();
                } else if ("deleted".equals(memberName)) {
                    this.deleted = true;
                } else if ("thumbnailSets".equals(memberName)) {
                    this.parseThumbnailsMember(value.asArray());
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException("Parse failed, maybe a bug in client.", e);
            }
        }

        private void parseThumbnailsMember(JsonArray thumbnails) {
            this.thumbnailSets = new ArrayList<OneDriveThumbnailSet.Metadata>(thumbnails.size());
            for (JsonValue value : thumbnails) {
                OneDriveThumbnailSet thumbnailSet;
                JsonObject thumbnail = value.asObject();
                int id = Integer.parseInt(thumbnail.get("id").asString());
                OneDriveThumbnailSet oneDriveThumbnailSet = thumbnailSet = new OneDriveThumbnailSet(OneDriveItem.this.getApi(), this.getId(), id);
                oneDriveThumbnailSet.getClass();
                this.thumbnailSets.add(new OneDriveThumbnailSet.Metadata(oneDriveThumbnailSet, thumbnail));
            }
        }

        public boolean isFolder() {
            return false;
        }

        public boolean isFile() {
            return false;
        }

        public OneDriveFolder.Metadata asFolder() {
            throw new UnsupportedOperationException("Not a folder.");
        }

        public OneDriveFile.Metadata asFile() {
            throw new UnsupportedOperationException("Not a file.");
        }
    }
}

