/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class RedisPoolExecutor
implements RedisExecutor {
    private static final Log log = LogFactory.getLog(RedisPoolExecutor.class);
    private Thread monitorThread;
    protected Pool<Jedis> pool;

    public RedisPoolExecutor(Pool<Jedis> pool) {
        this.pool = pool;
    }

    @Override
    public <T> T execute(RedisCallable<T> callable) throws JedisException {
        if (this.monitorThread != null) {
            log.debug((Object)String.format("Redis pool state before getting a conn: active: %d, idle: %s", this.pool.getNumActive(), this.pool.getNumIdle()));
        }
        Jedis jedis = (Jedis)this.pool.getResource();
        if (this.monitorThread != null) {
            log.debug((Object)("Using conn: " + jedis.getClient().getSocket().getLocalPort()));
        }
        boolean brokenResource = false;
        try {
            T t = callable.call(jedis);
            return t;
        }
        catch (JedisConnectionException cause) {
            brokenResource = true;
            throw cause;
        }
        finally {
            if (brokenResource || !jedis.isConnected()) {
                this.pool.returnBrokenResource((Object)jedis);
            } else {
                this.pool.returnResource((Object)jedis);
            }
        }
    }

    @Override
    public Pool<Jedis> getPool() {
        return this.pool;
    }

    @Override
    public void startMonitor() {
        final CountDownLatch monitorLatch = new CountDownLatch(1);
        this.monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                log.debug((Object)"Starting monitor thread");
                RedisPoolExecutor.this.execute(jedis -> {
                    jedis.monitor(new JedisMonitor(){

                        public void proceed(Client client) {
                            monitorLatch.countDown();
                            super.proceed(client);
                        }

                        public void onCommand(String command) {
                            if (Thread.currentThread().isInterrupted()) {
                                jedis.disconnect();
                            } else {
                                log.debug((Object)command);
                            }
                        }
                    });
                    log.debug((Object)"Monitor thread stopped");
                    return null;
                });
            }
        });
        this.monitorThread.setName("Nuxeo-Redis-Monitor");
        this.monitorThread.start();
        try {
            if (!monitorLatch.await(5L, TimeUnit.SECONDS)) {
                log.error((Object)"Failed to init Redis moniotring");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stopMonitor() {
        if (this.monitorThread != null) {
            log.debug((Object)"Stoping monitor");
            this.monitorThread.interrupt();
            this.monitorThread = null;
        }
    }
}

