/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.url.codec.api.DocumentViewCodec;
import org.nuxeo.ecm.platform.url.codec.descriptor.DocumentViewCodecDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentViewCodecService
extends DefaultComponent
implements DocumentViewCodecManager {
    private static final long serialVersionUID = -4521897334653742494L;
    private static final Log log = LogFactory.getLog(DocumentViewCodecService.class);
    public static final String NAME = DocumentViewCodecService.class.getName();
    public static final String CODECS_EXTENSION_POINT = "codecs";
    protected String defaultCodecName;
    protected final Map<String, DocumentViewCodecDescriptor> descriptors = new ConcurrentHashMap<String, DocumentViewCodecDescriptor>();
    protected final Map<String, DocumentViewCodec> codecs = new ConcurrentHashMap<String, DocumentViewCodec>();

    public void deactivate(ComponentContext context) {
        this.descriptors.clear();
        this.codecs.clear();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(DocumentViewCodecManager.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CODECS_EXTENSION_POINT.equals(extensionPoint)) {
            DocumentViewCodec codec;
            String className;
            DocumentViewCodecDescriptor desc = (DocumentViewCodecDescriptor)contribution;
            String codecName = desc.getName();
            this.descriptors.put(codecName, desc);
            if (desc.getDefaultCodec()) {
                this.defaultCodecName = codecName;
            }
            if ((className = desc.getClassName()) == null) {
                throw new IllegalArgumentException(String.format("Invalid class for codec '%s': check ERROR logs at startup", codecName));
            }
            try {
                codec = (DocumentViewCodec)DocumentViewCodecManager.class.getClassLoader().loadClass(className).newInstance();
            }
            catch (ReflectiveOperationException e) {
                String msg = String.format("Caught error when instantiating codec '%s' with class '%s' ", codecName, className);
                throw new IllegalArgumentException(msg, e);
            }
            String prefix = desc.getPrefix();
            if (prefix != null) {
                codec.setPrefix(prefix);
            }
            this.codecs.put(codecName, codec);
            log.debug((Object)("Added URL codec: " + codecName));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CODECS_EXTENSION_POINT.equals(extensionPoint)) {
            DocumentViewCodecDescriptor codecDesc = (DocumentViewCodecDescriptor)contribution;
            String codecName = codecDesc.getName();
            this.descriptors.remove(codecName);
            this.codecs.remove(codecName);
            log.debug((Object)("Removed URL codec: " + codecName));
        }
    }

    public List<String> getDocumentViewCodecDescriptorNames() {
        ArrayList<String> lst = new ArrayList<String>();
        for (String k : this.descriptors.keySet()) {
            if (!this.descriptors.get(k).getEnabled()) continue;
            lst.add(k);
        }
        return lst;
    }

    public String getDefaultCodecName() {
        List<String> descs;
        String name = this.defaultCodecName;
        if (name == null && (descs = this.getDocumentViewCodecDescriptorNames()) != null && !descs.isEmpty()) {
            Collections.sort(descs);
            name = descs.get(0);
        }
        return name;
    }

    public DocumentViewCodec getCodec() {
        return this.getCodec(this.defaultCodecName);
    }

    public DocumentViewCodec getCodec(String codecName) {
        if (StringUtils.isBlank((String)codecName)) {
            return null;
        }
        return this.codecs.get(codecName);
    }

    public String getUrlFromDocumentView(DocumentView docView, boolean needBaseUrl, String baseUrl) {
        String url;
        block2: {
            url = null;
            DocumentViewCodec codec = this.getCodec(this.getDefaultCodecName());
            if (codec != null && codec.handleDocumentView(docView)) {
                url = this.getUrlFromDocumentView(codec, docView, needBaseUrl, baseUrl);
            }
            if (url != null) break block2;
            for (String codecName : this.descriptors.keySet()) {
                if (!codecName.equals(this.defaultCodecName) && (codec = this.getCodec(codecName)) != null && codec.handleDocumentView(docView) && (url = this.getUrlFromDocumentView(codec, docView, needBaseUrl, baseUrl)) != null) break;
            }
        }
        return url;
    }

    public String getUrlFromDocumentView(String codecName, DocumentView docView, boolean needBaseUrl, String baseUrl) {
        DocumentViewCodec codec = this.getCodec(codecName);
        return this.getUrlFromDocumentView(codec, docView, needBaseUrl, baseUrl);
    }

    protected String getUrlFromDocumentView(DocumentViewCodec codec, DocumentView docView, boolean needBaseUrl, String baseUrl) {
        String partialUrl;
        if (codec != null && (partialUrl = codec.getUrlFromDocumentView(docView)) != null) {
            if (needBaseUrl && !StringUtils.isBlank((String)baseUrl)) {
                if (baseUrl.endsWith("/") || partialUrl.startsWith("/")) {
                    return baseUrl + partialUrl;
                }
                return baseUrl + "/" + partialUrl;
            }
            return partialUrl;
        }
        return null;
    }

    public DocumentView getDocumentViewFromUrl(String url, boolean hasBaseUrl, String baseUrl) {
        DocumentView docView;
        block2: {
            docView = null;
            String finalUrl = this.getUrlWithoutBase(url, hasBaseUrl, baseUrl);
            DocumentViewCodec codec = this.getCodec(this.getDefaultCodecName());
            if (codec != null && codec.handleUrl(finalUrl)) {
                docView = this.getDocumentViewFromUrl(codec, finalUrl);
            }
            if (docView != null) break block2;
            for (String codecName : this.descriptors.keySet()) {
                if (!codecName.equals(this.defaultCodecName) && (codec = this.getCodec(codecName)) != null && codec.handleUrl(finalUrl) && (docView = this.getDocumentViewFromUrl(codec, finalUrl)) != null) break;
            }
        }
        return docView;
    }

    public DocumentView getDocumentViewFromUrl(String codecName, String url, boolean hasBaseUrl, String baseUrl) {
        DocumentViewCodec codec = this.getCodec(codecName);
        String finalUrl = this.getUrlWithoutBase(url, hasBaseUrl, baseUrl);
        return this.getDocumentViewFromUrl(codec, finalUrl);
    }

    protected String getUrlWithoutBase(String url, boolean hasBaseUrl, String baseUrl) {
        if (hasBaseUrl && baseUrl != null && url.startsWith(baseUrl)) {
            url = url.substring(baseUrl.length());
        }
        return url;
    }

    protected DocumentView getDocumentViewFromUrl(DocumentViewCodec codec, String finalUrl) {
        if (codec != null) {
            DocumentView docView = codec.getDocumentViewFromUrl(finalUrl);
            return docView;
        }
        return null;
    }
}

