/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.task.Task;

public class RoutingTaskDeletedListener
implements EventListener {
    public void handleEvent(Event event) {
        if (!"aboutToRemove".equals(event.getName())) {
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        DocumentModel doc = docCtx.getSourceDocument();
        CoreSession session = docCtx.getCoreSession();
        if (doc.hasFacet("RoutingTask")) {
            Task task = (Task)doc.getAdapter(Task.class);
            String routeId = task.getProcessId();
            IdRef routeIdRef = new IdRef(routeId);
            if (StringUtils.isNotBlank((String)routeId) && session.exists((DocumentRef)routeIdRef)) {
                GraphRoute graphRoute = (GraphRoute)session.getDocument((DocumentRef)routeIdRef).getAdapter(GraphRoute.class);
                String nodeId = task.getVariable("nodeId");
                if (StringUtils.isNotBlank((String)nodeId)) {
                    GraphNode graphNode = graphRoute.getNode(nodeId);
                    graphNode.removeTaskInfo(task.getId());
                }
            }
        }
    }
}

