/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.coreiodelegate;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.context.RenderingContextImpl;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.ecm.webengine.jaxrs.coreiodelegate.VirtualHostHelper;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.runtime.api.Framework;

public final class RenderingContextWebUtils {
    private static final String CTX_KEY = "_STORED_GENERATED_RENDERING_CONTEXT";
    public static final String REQUEST_KEY = "_STORED_GENERATED_HTTP_SERVLET_REQUEST";

    private RenderingContextWebUtils() {
    }

    public static RenderingContext getContext(ServletRequest request) {
        Object stored = request.getAttribute(RenderingContextWebUtils.getContextKey());
        if (stored != null) {
            return (RenderingContext)stored;
        }
        RenderingContextImpl.RenderingContextBuilder builder = RenderingContext.CtxBuilder.builder();
        RenderingContextWebUtils.fillContext(builder, request);
        RenderingContext ctx = builder.get();
        RenderingContextWebUtils.registerContext(request, ctx);
        return ctx;
    }

    public static void registerContext(ServletRequest request, RenderingContext ctx) {
        request.setAttribute(RenderingContextWebUtils.getContextKey(), (Object)ctx);
    }

    public static String getContextKey() {
        return CTX_KEY;
    }

    public static RenderingContextImpl.RenderingContextBuilder getBuilder(ServletRequest request) {
        RenderingContextImpl.RenderingContextBuilder builder = RenderingContext.CtxBuilder.builder();
        RenderingContextWebUtils.fillContext(builder, request);
        return builder;
    }

    public static RenderingContextImpl.RenderingContextBuilder fillContext(RenderingContextImpl.RenderingContextBuilder builder, ServletRequest request) {
        builder.param(REQUEST_KEY, (Object)request);
        if (request instanceof HttpServletRequest) {
            HttpServletRequest webRequest = (HttpServletRequest)request;
            String string = VirtualHostHelper.getBaseURL((ServletRequest)webRequest);
            CoreSession session = SessionFactory.getSession(webRequest);
            builder.base(string).session(session);
            Locale locale = null;
            LocaleProvider localeProvider = (LocaleProvider)Framework.getService(LocaleProvider.class);
            if (localeProvider != null) {
                locale = localeProvider.getLocale(session);
            }
            if (locale == null) {
                locale = request.getLocale();
            }
            if (locale != null) {
                builder.locale(locale);
            }
            Enumeration headerNames = webRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = webRequest.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    builder.param(headerName, headerValues.nextElement());
                }
            }
        }
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            builder.paramValues((String)entry.getKey(), (Object[])entry.getValue());
        }
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String string = (String)attributeNames.nextElement();
            Object attributeValue = request.getAttribute(string);
            builder.param(string, attributeValue);
        }
        return builder;
    }
}

