/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.InternalSearchHit;

public class InternalSearchHits
implements SearchHits {
    private static final ThreadLocal<StreamContext> cache = new ThreadLocal<StreamContext>(){

        @Override
        protected StreamContext initialValue() {
            return new StreamContext();
        }
    };
    public static final InternalSearchHit[] EMPTY = new InternalSearchHit[0];
    private InternalSearchHit[] hits;
    public long totalHits;
    private float maxScore;

    public static StreamContext streamContext() {
        return cache.get().reset();
    }

    public static InternalSearchHits empty() {
        return new InternalSearchHits(EMPTY, 0L, 0.0f);
    }

    InternalSearchHits() {
    }

    public InternalSearchHits(InternalSearchHit[] hits, long totalHits, float maxScore) {
        this.hits = hits;
        this.totalHits = totalHits;
        this.maxScore = maxScore;
    }

    public void shardTarget(SearchShardTarget shardTarget) {
        for (InternalSearchHit hit : this.hits) {
            hit.shard(shardTarget);
        }
    }

    @Override
    public long totalHits() {
        return this.totalHits;
    }

    @Override
    public long getTotalHits() {
        return this.totalHits();
    }

    @Override
    public float maxScore() {
        return this.maxScore;
    }

    @Override
    public float getMaxScore() {
        return this.maxScore();
    }

    @Override
    public SearchHit[] hits() {
        return this.hits;
    }

    @Override
    public SearchHit getAt(int position) {
        return this.hits[position];
    }

    @Override
    public SearchHit[] getHits() {
        return this.hits();
    }

    @Override
    public Iterator<SearchHit> iterator() {
        return Iterators.forArray(this.hits());
    }

    public InternalSearchHit[] internalHits() {
        return this.hits;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.HITS);
        builder.field(Fields.TOTAL, this.totalHits);
        if (Float.isNaN(this.maxScore)) {
            builder.nullField(Fields.MAX_SCORE);
        } else {
            builder.field(Fields.MAX_SCORE, this.maxScore);
        }
        builder.field(Fields.HITS);
        builder.startArray();
        for (InternalSearchHit hit : this.hits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalSearchHits readSearchHits(StreamInput in, StreamContext context) throws IOException {
        InternalSearchHits hits = new InternalSearchHits();
        hits.readFrom(in, context);
        return hits;
    }

    public static InternalSearchHits readSearchHits(StreamInput in) throws IOException {
        InternalSearchHits hits = new InternalSearchHits();
        hits.readFrom(in);
        return hits;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.readFrom(in, InternalSearchHits.streamContext().streamShardTarget(StreamContext.ShardTargetType.LOOKUP));
    }

    public void readFrom(StreamInput in, StreamContext context) throws IOException {
        this.totalHits = in.readVLong();
        this.maxScore = in.readFloat();
        int size = in.readVInt();
        if (size == 0) {
            this.hits = EMPTY;
        } else {
            if (context.streamShardTarget() == StreamContext.ShardTargetType.LOOKUP) {
                int lookupSize = in.readVInt();
                for (int i = 0; i < lookupSize; ++i) {
                    context.handleShardLookup().put(in.readVInt(), SearchShardTarget.readSearchShardTarget(in));
                }
            }
            this.hits = new InternalSearchHit[size];
            for (int i = 0; i < this.hits.length; ++i) {
                this.hits[i] = InternalSearchHit.readSearchHit(in, context);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.writeTo(out, InternalSearchHits.streamContext().streamShardTarget(StreamContext.ShardTargetType.LOOKUP));
    }

    public void writeTo(StreamOutput out, StreamContext context) throws IOException {
        out.writeVLong(this.totalHits);
        out.writeFloat(this.maxScore);
        out.writeVInt(this.hits.length);
        if (this.hits.length > 0) {
            if (context.streamShardTarget() == StreamContext.ShardTargetType.LOOKUP) {
                int counter = 1;
                for (InternalSearchHit hit : this.hits) {
                    Integer handle;
                    if (hit.shard() == null || (handle = context.shardHandleLookup().get(hit.shard())) != null) continue;
                    context.shardHandleLookup().put(hit.shard(), counter++);
                }
                out.writeVInt(context.shardHandleLookup().size());
                if (!context.shardHandleLookup().isEmpty()) {
                    for (Map.Entry<SearchShardTarget, Integer> entry : context.shardHandleLookup().entrySet()) {
                        out.writeVInt(entry.getValue());
                        entry.getKey().writeTo(out);
                    }
                }
            }
            for (InternalSearchHit hit : this.hits) {
                hit.writeTo(out, context);
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString HITS = new XContentBuilderString("hits");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MAX_SCORE = new XContentBuilderString("max_score");

        Fields() {
        }
    }

    public static class StreamContext {
        private IdentityHashMap<SearchShardTarget, Integer> shardHandleLookup = new IdentityHashMap();
        private IntObjectOpenHashMap<SearchShardTarget> handleShardLookup = new IntObjectOpenHashMap();
        private ShardTargetType streamShardTarget = ShardTargetType.STREAM;

        public StreamContext reset() {
            this.shardHandleLookup.clear();
            this.handleShardLookup.clear();
            this.streamShardTarget = ShardTargetType.STREAM;
            return this;
        }

        public IdentityHashMap<SearchShardTarget, Integer> shardHandleLookup() {
            return this.shardHandleLookup;
        }

        public IntObjectOpenHashMap<SearchShardTarget> handleShardLookup() {
            return this.handleShardLookup;
        }

        public ShardTargetType streamShardTarget() {
            return this.streamShardTarget;
        }

        public StreamContext streamShardTarget(ShardTargetType streamShardTarget) {
            this.streamShardTarget = streamShardTarget;
            return this;
        }

        public static enum ShardTargetType {
            STREAM,
            LOOKUP,
            NO_STREAM;

        }
    }
}

