/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.util.Collections;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

abstract class AbstractStringTermsAggregator
extends TermsAggregator {
    protected final boolean showTermDocCountError;

    public AbstractStringTermsAggregator(String name, AggregatorFactories factories, long estimatedBucketsCount, AggregationContext context, Aggregator parent, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, estimatedBucketsCount, context, parent, bucketCountThresholds, order, subAggCollectMode);
        this.showTermDocCountError = showTermDocCountError;
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getShardSize(), this.bucketCountThresholds.getMinDocCount(), Collections.emptyList(), this.showTermDocCountError, 0L, 0L);
    }
}

