/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ChiSquare;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.GND;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.MutualInformation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.PercentageScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ScriptHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;

public class TransportSignificantTermsHeuristicModule
extends AbstractModule {
    private List<SignificanceHeuristicStreams.Stream> streams = Lists.newArrayList();

    public TransportSignificantTermsHeuristicModule() {
        this.registerStream(JLHScore.STREAM);
        this.registerStream(PercentageScore.STREAM);
        this.registerStream(MutualInformation.STREAM);
        this.registerStream(GND.STREAM);
        this.registerStream(ChiSquare.STREAM);
        this.registerStream(ScriptHeuristic.STREAM);
    }

    public void registerStream(SignificanceHeuristicStreams.Stream stream) {
        this.streams.add(stream);
    }

    @Override
    protected void configure() {
        for (SignificanceHeuristicStreams.Stream stream : this.streams) {
            SignificanceHeuristicStreams.registerStream(stream, stream.getName());
        }
    }
}

