/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class HistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Numeric valuesSource;
    @Nullable
    private final ValueFormatter formatter;
    private final Rounding rounding;
    private final InternalOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final ExtendedBounds extendedBounds;
    private final InternalHistogram.Factory histogramFactory;
    private final LongHash bucketOrds;
    private SortedNumericDocValues values;

    public HistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, InternalOrder order, boolean keyed, long minDocCount, @Nullable ExtendedBounds extendedBounds, @Nullable ValuesSource.Numeric valuesSource, @Nullable ValueFormatter formatter, long initialCapacity, InternalHistogram.Factory<?> histogramFactory, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, initialCapacity, aggregationContext, parent);
        this.rounding = rounding;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.histogramFactory = histogramFactory;
        this.bucketOrds = new LongHash(initialCapacity, aggregationContext.bigArrays());
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.longValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        this.values.setDocument(doc);
        int valuesCount = this.values.count();
        long previousKey = Long.MIN_VALUE;
        for (int i = 0; i < valuesCount; ++i) {
            long value = this.values.valueAt(i);
            long key = this.rounding.roundKey(value);
            assert (key >= previousKey);
            if (key == previousKey) continue;
            long bucketOrd = this.bucketOrds.add(key);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                this.collectExistingBucket(doc, bucketOrd);
            } else {
                this.collectBucket(doc, bucketOrd);
            }
            previousKey = key;
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        ArrayList buckets = new ArrayList((int)this.bucketOrds.size());
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            buckets.add(this.histogramFactory.createBucket(this.rounding.valueForKey(this.bucketOrds.get(i)), this.bucketDocCount(i), this.bucketAggregations(i), this.formatter));
        }
        CollectionUtil.introSort(buckets, this.order.comparator());
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return this.histogramFactory.create(this.name, buckets, this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return this.histogramFactory.create(this.name, Collections.emptyList(), this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory<ValuesSource.Numeric> {
        private final Rounding rounding;
        private final InternalOrder order;
        private final boolean keyed;
        private final long minDocCount;
        private final ExtendedBounds extendedBounds;
        private final InternalHistogram.Factory<?> histogramFactory;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> config, Rounding rounding, InternalOrder order, boolean keyed, long minDocCount, ExtendedBounds extendedBounds, InternalHistogram.Factory<?> histogramFactory) {
            super(name, histogramFactory.type(), config);
            this.rounding = rounding;
            this.order = order;
            this.keyed = keyed;
            this.minDocCount = minDocCount;
            this.extendedBounds = extendedBounds;
            this.histogramFactory = histogramFactory;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new HistogramAggregator(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, null, null, this.config.formatter(), 0L, this.histogramFactory, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(ValuesSource.Numeric valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            long estimatedBucketCount = 50L;
            if (Aggregator.hasParentBucketAggregator(parent)) {
                estimatedBucketCount = 8L;
            }
            ExtendedBounds roundedBounds = null;
            if (this.extendedBounds != null) {
                this.extendedBounds.processAndValidate(this.name, aggregationContext.searchContext(), this.config.parser());
                roundedBounds = this.extendedBounds.round(this.rounding);
            }
            return new HistogramAggregator(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, roundedBounds, valuesSource, this.config.formatter(), estimatedBucketCount, this.histogramFactory, aggregationContext, parent);
        }
    }
}

