/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.aggregations.AggregationBinaryParseElement;
import org.elasticsearch.search.aggregations.AggregationParseElement;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public class AggregationPhase
implements SearchPhase {
    private final AggregationParseElement parseElement;
    private final AggregationBinaryParseElement binaryParseElement;

    @Inject
    public AggregationPhase(AggregationParseElement parseElement, AggregationBinaryParseElement binaryParseElement) {
        this.parseElement = parseElement;
        this.binaryParseElement = binaryParseElement;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.builder().put("aggregations", this.parseElement).put("aggs", this.parseElement).put("aggregations_binary", this.binaryParseElement).put("aggregationsBinary", this.binaryParseElement).put("aggs_binary", this.binaryParseElement).put("aggsBinary", this.binaryParseElement).build();
    }

    @Override
    public void preProcess(SearchContext context) {
        if (context.aggregations() != null) {
            AggregationContext aggregationContext = new AggregationContext(context);
            context.aggregations().aggregationContext(aggregationContext);
            ArrayList<Aggregator> collectors = new ArrayList<Aggregator>();
            Aggregator[] aggregators = context.aggregations().factories().createTopLevelAggregators(aggregationContext);
            for (int i = 0; i < aggregators.length; ++i) {
                Aggregator aggregator;
                if (aggregators[i] instanceof GlobalAggregator || !(aggregator = aggregators[i]).shouldCollect()) continue;
                collectors.add(aggregator);
            }
            context.aggregations().aggregators(aggregators);
            if (!collectors.isEmpty()) {
                context.searcher().addMainQueryCollector(new AggregationsCollector(collectors, aggregationContext));
            }
            aggregationContext.setNextReader(context.searcher().getIndexReader().getContext());
        }
    }

    @Override
    public void execute(SearchContext context) throws ElasticsearchException {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        if (context.queryResult().aggregations() != null) {
            return;
        }
        Aggregator[] aggregators = context.aggregations().aggregators();
        ArrayList<Aggregator> globals = new ArrayList<Aggregator>();
        for (int i = 0; i < aggregators.length; ++i) {
            if (!(aggregators[i] instanceof GlobalAggregator)) continue;
            globals.add(aggregators[i]);
        }
        if (!globals.isEmpty()) {
            AggregationsCollector collector = new AggregationsCollector(globals, context.aggregations().aggregationContext());
            Object query = new XConstantScoreQuery(Queries.MATCH_ALL_FILTER);
            Filter searchFilter = context.searchFilter(context.types());
            if (searchFilter != null) {
                query = new XFilteredQuery((Query)query, searchFilter);
            }
            try {
                context.searcher().search((Query)query, collector);
                collector.postCollection();
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(context, "Failed to execute global aggregators", (Throwable)e);
            }
        }
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>(aggregators.length);
        for (Aggregator aggregator : context.aggregations().aggregators()) {
            aggregations.add(aggregator.buildAggregation(0L));
        }
        context.queryResult().aggregations(new InternalAggregations(aggregations));
        context.aggregations(null);
    }

    public static class AggregationsCollector
    extends XCollector {
        private final AggregationContext aggregationContext;
        private final Aggregator[] collectors;

        public AggregationsCollector(Collection<Aggregator> collectors, AggregationContext aggregationContext) {
            this.collectors = collectors.toArray(new Aggregator[collectors.size()]);
            this.aggregationContext = aggregationContext;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.aggregationContext.setScorer(scorer);
        }

        public void collect(int doc) throws IOException {
            for (Aggregator collector : this.collectors) {
                collector.collect(doc, 0L);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.aggregationContext.setNextReader(context);
        }

        public boolean acceptsDocsOutOfOrder() {
            return !this.aggregationContext.scoreDocsInOrder();
        }

        @Override
        public void postCollection() throws IOException {
            for (Aggregator collector : this.collectors) {
                collector.postCollection();
            }
        }
    }
}

