/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.optimize;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.action.admin.indices.optimize.OptimizeResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestOptimizeAction
extends BaseRestHandler {
    @Inject
    public RestOptimizeAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_optimize", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_optimize", this);
        controller.registerHandler(RestRequest.Method.GET, "/_optimize", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_optimize", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        OptimizeRequest optimizeRequest = new OptimizeRequest(Strings.splitStringByCommaToArray(request.param("index")));
        optimizeRequest.listenerThreaded(false);
        optimizeRequest.indicesOptions(IndicesOptions.fromRequest(request, optimizeRequest.indicesOptions()));
        optimizeRequest.maxNumSegments(request.paramAsInt("max_num_segments", optimizeRequest.maxNumSegments()));
        optimizeRequest.onlyExpungeDeletes(request.paramAsBoolean("only_expunge_deletes", optimizeRequest.onlyExpungeDeletes()));
        optimizeRequest.flush(request.paramAsBoolean("flush", optimizeRequest.flush()));
        optimizeRequest.force(request.paramAsBoolean("force", optimizeRequest.force()));
        client.admin().indices().optimize(optimizeRequest, (ActionListener<OptimizeResponse>)new RestBuilderListener<OptimizeResponse>(channel){

            @Override
            public RestResponse buildResponse(OptimizeResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, response);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

