/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MatchQuery {
    protected final QueryParseContext parseContext;
    protected String analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected Fuzziness fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected boolean transpositions = false;
    protected MultiTermQuery.RewriteMethod rewriteMethod;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient;
    protected ZeroTermsQuery zeroTermsQuery = ZeroTermsQuery.NONE;
    protected Float commonTermsCutoff = null;

    public MatchQuery(QueryParseContext parseContext) {
        this.parseContext = parseContext;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setCommonTermsCutoff(float cutoff) {
        this.commonTermsCutoff = Float.valueOf(cutoff);
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setRewriteMethod(MultiTermQuery.RewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    protected boolean forceAnalyzeQueryString() {
        return false;
    }

    protected Analyzer getAnalyzer(FieldMapper mapper, MapperService.SmartNameFieldMappers smartNameFieldMappers) {
        Object analyzer = null;
        if (this.analyzer == null) {
            if (mapper != null) {
                analyzer = mapper.searchAnalyzer();
            }
            if (analyzer == null && smartNameFieldMappers != null) {
                analyzer = smartNameFieldMappers.searchAnalyzer();
            }
            if (analyzer == null) {
                analyzer = this.parseContext.mapperService().searchAnalyzer();
            }
        } else {
            analyzer = this.parseContext.mapperService().analysisService().analyzer(this.analyzer);
            if (analyzer == null) {
                throw new ElasticsearchIllegalArgumentException("No analyzer found for [" + this.analyzer + "]");
            }
        }
        return analyzer;
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        String field;
        FieldMapper mapper = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = this.parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            mapper = smartNameFieldMappers.mapper();
            field = mapper.names().indexName();
        } else {
            field = fieldName;
        }
        if (mapper != null && mapper.useTermQueryWithQueryString() && !this.forceAnalyzeQueryString()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    Query query = QueryParsers.wrapSmartNameQuery(mapper.termQuery(value, this.parseContext), smartNameFieldMappers, this.parseContext);
                    return query;
                }
                catch (RuntimeException e) {
                    if (this.lenient) {
                        Query query = null;
                        return query;
                    }
                    throw e;
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            }
            try {
                return QueryParsers.wrapSmartNameQuery(mapper.termQuery(value, this.parseContext), smartNameFieldMappers, this.parseContext);
            }
            catch (RuntimeException e) {
                if (this.lenient) {
                    return null;
                }
                throw e;
            }
        }
        Analyzer analyzer = this.getAnalyzer(mapper, smartNameFieldMappers);
        MatchQueryBuilder builder = new MatchQueryBuilder(analyzer, mapper);
        builder.setEnablePositionIncrements(this.enablePositionIncrements);
        Query query = null;
        switch (type) {
            case BOOLEAN: {
                if (this.commonTermsCutoff == null) {
                    query = builder.createBooleanQuery(field, value.toString(), this.occur);
                    break;
                }
                query = builder.createCommonTermsQuery(field, value.toString(), this.occur, this.occur, this.commonTermsCutoff.floatValue(), mapper);
                break;
            }
            case PHRASE: {
                query = builder.createPhraseQuery(field, value.toString(), this.phraseSlop);
                break;
            }
            case PHRASE_PREFIX: {
                query = builder.createPhrasePrefixQuery(field, value.toString(), this.phraseSlop, this.maxExpansions);
                break;
            }
            default: {
                throw new ElasticsearchIllegalStateException("No type found for [" + (Object)((Object)type) + "]");
            }
        }
        if (query == null) {
            return this.zeroTermsQuery();
        }
        return QueryParsers.wrapSmartNameQuery(query, smartNameFieldMappers, this.parseContext);
    }

    protected Query zeroTermsQuery() {
        return this.zeroTermsQuery == ZeroTermsQuery.NONE ? Queries.newMatchNoDocsQuery() : Queries.newMatchAllQuery();
    }

    protected Query blendTermQuery(Term term, FieldMapper mapper) {
        Query termQuery;
        if (this.fuzziness != null) {
            Query query;
            if (mapper != null && (query = mapper.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions)) instanceof FuzzyQuery) {
                QueryParsers.setRewriteMethod((MultiTermQuery)((FuzzyQuery)query), this.fuzzyRewriteMethod);
            }
            int edits = this.fuzziness.asDistance(term.text());
            FuzzyQuery query2 = new FuzzyQuery(term, edits, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
            QueryParsers.setRewriteMethod((MultiTermQuery)query2, this.rewriteMethod);
            return query2;
        }
        if (mapper != null && (termQuery = mapper.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return new TermQuery(term);
    }

    private class MatchQueryBuilder
    extends QueryBuilder {
        private final FieldMapper mapper;

        public MatchQueryBuilder(@Nullable Analyzer analyzer, FieldMapper mapper) {
            super(analyzer);
            this.mapper = mapper;
        }

        protected Query newTermQuery(Term term) {
            return MatchQuery.this.blendTermQuery(term, this.mapper);
        }

        public Query createPhrasePrefixQuery(String field, String queryText, int phraseSlop, int maxExpansions) {
            Query query = this.createFieldQuery(this.getAnalyzer(), BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
            MultiPhrasePrefixQuery prefixQuery = new MultiPhrasePrefixQuery();
            prefixQuery.setMaxExpansions(maxExpansions);
            prefixQuery.setSlop(phraseSlop);
            if (query instanceof PhraseQuery) {
                PhraseQuery pq = (PhraseQuery)query;
                Term[] terms = pq.getTerms();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(new Term[]{terms[i]}, positions[i]);
                }
                return prefixQuery;
            }
            if (query instanceof MultiPhraseQuery) {
                MultiPhraseQuery pq = (MultiPhraseQuery)query;
                List terms = pq.getTermArrays();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.size(); ++i) {
                    prefixQuery.add((Term[])terms.get(i), positions[i]);
                }
                return prefixQuery;
            }
            if (query instanceof TermQuery) {
                prefixQuery.add(((TermQuery)query).getTerm());
                return prefixQuery;
            }
            return query;
        }

        public Query createCommonTermsQuery(String field, String queryText, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, FieldMapper<?> mapper) {
            Query booleanQuery = this.createBooleanQuery(field, queryText, lowFreqOccur);
            if (booleanQuery != null && booleanQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)booleanQuery;
                ExtendedCommonTermsQuery query = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency, ((BooleanQuery)booleanQuery).isCoordDisabled(), mapper);
                for (BooleanClause clause : bq.clauses()) {
                    if (!(clause.getQuery() instanceof TermQuery)) {
                        return booleanQuery;
                    }
                    query.add(((TermQuery)clause.getQuery()).getTerm());
                }
                return query;
            }
            return booleanQuery;
        }
    }

    public static enum ZeroTermsQuery {
        NONE,
        ALL;

    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }
}

