/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanNotQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder,
BoostableQueryBuilder<SpanNotQueryBuilder> {
    private SpanQueryBuilder include;
    private SpanQueryBuilder exclude;
    private Integer dist;
    private Integer pre;
    private Integer post;
    private Float boost;
    private String queryName;

    public SpanNotQueryBuilder include(SpanQueryBuilder include) {
        this.include = include;
        return this;
    }

    public SpanNotQueryBuilder exclude(SpanQueryBuilder exclude) {
        this.exclude = exclude;
        return this;
    }

    public SpanNotQueryBuilder dist(int dist) {
        this.dist = dist;
        return this;
    }

    public SpanNotQueryBuilder pre(int pre) {
        this.pre = pre >= 0 ? pre : 0;
        return this;
    }

    public SpanNotQueryBuilder post(int post) {
        this.post = post >= 0 ? post : 0;
        return this;
    }

    @Override
    public SpanNotQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public SpanNotQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.include == null) {
            throw new ElasticsearchIllegalArgumentException("Must specify include when using spanNot query");
        }
        if (this.exclude == null) {
            throw new ElasticsearchIllegalArgumentException("Must specify exclude when using spanNot query");
        }
        if (this.dist != null && (this.pre != null || this.post != null)) {
            throw new ElasticsearchIllegalArgumentException("spanNot can either use [dist] or [pre] & [post] (or none)");
        }
        builder.startObject("span_not");
        builder.field("include");
        this.include.toXContent(builder, params);
        builder.field("exclude");
        this.exclude.toXContent(builder, params);
        if (this.dist != null) {
            builder.field("dist", this.dist);
        }
        if (this.pre != null) {
            builder.field("pre", this.pre);
        }
        if (this.post != null) {
            builder.field("post", this.post);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

