/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ordinals.InternalGlobalOrdinalsIndexFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public final class GlobalOrdinalsBuilder
extends Enum<GlobalOrdinalsBuilder> {
    private static final /* synthetic */ GlobalOrdinalsBuilder[] $VALUES;

    public static GlobalOrdinalsBuilder[] values() {
        return (GlobalOrdinalsBuilder[])$VALUES.clone();
    }

    public static GlobalOrdinalsBuilder valueOf(String name) {
        return Enum.valueOf(GlobalOrdinalsBuilder.class, name);
    }

    public static IndexOrdinalsFieldData build(IndexReader indexReader, IndexOrdinalsFieldData indexFieldData, Settings settings, CircuitBreakerService breakerService, ESLogger logger) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTime = System.currentTimeMillis();
        AtomicOrdinalsFieldData[] atomicFD = new AtomicOrdinalsFieldData[indexReader.leaves().size()];
        RandomAccessOrds[] subs = new RandomAccessOrds[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = (AtomicOrdinalsFieldData)indexFieldData.load((AtomicReaderContext)indexReader.leaves().get(i));
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(null, (SortedSetDocValues[])subs, (float)0.25f);
        long memorySizeInBytes = ordinalMap.ramBytesUsed();
        breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA).addWithoutBreaking(memorySizeInBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("Global-ordinals[{}][{}] took {} ms", indexFieldData.getFieldNames().fullName(), ordinalMap.getValueCount(), System.currentTimeMillis() - startTime);
        }
        return new InternalGlobalOrdinalsIndexFieldData(indexFieldData.index(), settings, indexFieldData.getFieldNames(), indexFieldData.getFieldDataType(), atomicFD, ordinalMap, memorySizeInBytes);
    }

    static {
        $VALUES = new GlobalOrdinalsBuilder[0];
    }
}

