/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatService;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormats;
import org.elasticsearch.index.codec.docvaluesformat.PreBuiltDocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingFormats;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatService;
import org.elasticsearch.index.codec.postingsformat.PreBuiltPostingsFormatProvider;

public class CodecModule
extends AbstractModule {
    private final Settings indexSettings;
    private final Map<String, Class<? extends PostingsFormatProvider>> customPostingsFormatProviders = Maps.newHashMap();
    private final Map<String, Class<? extends DocValuesFormatProvider>> customDocValuesFormatProviders = Maps.newHashMap();

    public CodecModule(Settings indexSettings) {
        this.indexSettings = indexSettings;
    }

    public CodecModule addPostingFormat(String name, Class<? extends PostingsFormatProvider> provider) {
        this.customPostingsFormatProviders.put(name, provider);
        return this;
    }

    public CodecModule addDocValuesFormat(String name, Class<? extends DocValuesFormatProvider> provider) {
        this.customDocValuesFormatProviders.put(name, provider);
        return this;
    }

    private void configurePostingsFormats() {
        HashMap<String, Class<? extends PostingsFormatProvider>> postingFormatProviders = Maps.newHashMap(this.customPostingsFormatProviders);
        Map<String, Settings> postingsFormatsSettings = this.indexSettings.getGroups("index.codec.postings_format");
        for (Map.Entry<String, Settings> entry : postingsFormatsSettings.entrySet()) {
            Class type;
            String name = entry.getKey();
            Settings settings = entry.getValue();
            String sType = settings.get("type");
            if (sType == null || sType.trim().isEmpty()) {
                throw new ElasticsearchIllegalArgumentException("PostingsFormat Factory [" + name + "] must have a type associated with it");
            }
            try {
                type = settings.getAsClass("type", null, "org.elasticsearch.index.codec.postingsformat.", "PostingsFormatProvider");
            }
            catch (NoClassSettingsException e) {
                throw new ElasticsearchIllegalArgumentException("The specified type [" + sType + "] for postingsFormat Factory [" + name + "] can't be found");
            }
            postingFormatProviders.put(name, type);
        }
        MapBinder<String, PostingsFormatProvider.Factory> postingFormatFactoryBinder = MapBinder.newMapBinder(this.binder(), String.class, PostingsFormatProvider.Factory.class);
        for (Map.Entry entry : postingFormatProviders.entrySet()) {
            postingFormatFactoryBinder.addBinding((String)entry.getKey()).toProvider(FactoryProvider.newFactory(PostingsFormatProvider.Factory.class, (Class)entry.getValue())).in(Scopes.SINGLETON);
        }
        for (PreBuiltPostingsFormatProvider.Factory factory : PostingFormats.listFactories()) {
            if (postingFormatProviders.containsKey(factory.name())) continue;
            postingFormatFactoryBinder.addBinding(factory.name()).toInstance(factory);
        }
        this.bind(PostingsFormatService.class).asEagerSingleton();
    }

    private void configureDocValuesFormats() {
        HashMap<String, Class<? extends DocValuesFormatProvider>> docValuesFormatProviders = Maps.newHashMap(this.customDocValuesFormatProviders);
        Map<String, Settings> docValuesFormatSettings = this.indexSettings.getGroups("index.codec.doc_values_format");
        for (Map.Entry<String, Settings> entry : docValuesFormatSettings.entrySet()) {
            Class type;
            String name = entry.getKey();
            Settings settings = entry.getValue();
            String sType = settings.get("type");
            if (sType == null || sType.trim().isEmpty()) {
                throw new ElasticsearchIllegalArgumentException("DocValuesFormat Factory [" + name + "] must have a type associated with it");
            }
            try {
                type = settings.getAsClass("type", null, "org.elasticsearch.index.codec.docvaluesformat.", "DocValuesFormatProvider");
            }
            catch (NoClassSettingsException e) {
                throw new ElasticsearchIllegalArgumentException("The specified type [" + sType + "] for docValuesFormat Factory [" + name + "] can't be found");
            }
            docValuesFormatProviders.put(name, type);
        }
        MapBinder<String, DocValuesFormatProvider.Factory> docValuesFormatFactoryBinder = MapBinder.newMapBinder(this.binder(), String.class, DocValuesFormatProvider.Factory.class);
        for (Map.Entry entry : docValuesFormatProviders.entrySet()) {
            docValuesFormatFactoryBinder.addBinding((String)entry.getKey()).toProvider(FactoryProvider.newFactory(DocValuesFormatProvider.Factory.class, (Class)entry.getValue())).in(Scopes.SINGLETON);
        }
        for (PreBuiltDocValuesFormatProvider.Factory factory : DocValuesFormats.listFactories()) {
            if (docValuesFormatProviders.containsKey(factory.name())) continue;
            docValuesFormatFactoryBinder.addBinding(factory.name()).toInstance(factory);
        }
        this.bind(DocValuesFormatService.class).asEagerSingleton();
    }

    @Override
    protected void configure() {
        this.configurePostingsFormats();
        this.configureDocValuesFormats();
        this.bind(CodecService.class).asEagerSingleton();
    }
}

