/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.custom;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class SingleCustomOperationRequest<T extends SingleCustomOperationRequest>
extends ActionRequest<T>
implements IndicesRequest {
    private boolean threadedOperation = true;
    private boolean preferLocal = true;
    private String index;

    protected SingleCustomOperationRequest() {
    }

    protected SingleCustomOperationRequest(ActionRequest request) {
        super(request);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public boolean operationThreaded() {
        return this.threadedOperation;
    }

    public final T operationThreaded(boolean threadedOperation) {
        this.threadedOperation = threadedOperation;
        return (T)this;
    }

    public final T preferLocal(boolean preferLocal) {
        this.preferLocal = preferLocal;
        return (T)this;
    }

    public T index(String index) {
        this.index = index;
        return (T)this;
    }

    public String index() {
        return this.index;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    @Override
    public String[] indices() {
        if (this.index == null) {
            return Strings.EMPTY_ARRAY;
        }
        return new String[]{this.index};
    }

    public boolean preferLocalShard() {
        return this.preferLocal;
    }

    public void beforeLocalFork() {
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.preferLocal = in.readBoolean();
        this.readIndex(in);
    }

    protected void readIndex(StreamInput in) throws IOException {
        this.index = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.preferLocal);
        this.writeIndex(out);
    }

    protected void writeIndex(StreamOutput out) throws IOException {
        out.writeOptionalString(this.index);
    }
}

