/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.info.ClusterInfoRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.ObjectArrays;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetIndexRequest
extends ClusterInfoRequest<GetIndexRequest> {
    private static final Feature[] DEFAULT_FEATURES = new Feature[]{Feature.ALIASES, Feature.MAPPINGS, Feature.SETTINGS, Feature.WARMERS};
    private Feature[] features = DEFAULT_FEATURES;
    private boolean indicesOptionsSet = false;

    public GetIndexRequest features(Feature ... features) {
        if (features == null) {
            throw new ElasticsearchIllegalArgumentException("features cannot be null");
        }
        this.features = features;
        return this;
    }

    @Deprecated
    public GetIndexRequest features(String[] featureNames) {
        this.features(Feature.convertToFeatures(featureNames));
        return this;
    }

    public GetIndexRequest addFeatures(Feature ... features) {
        if (this.features == DEFAULT_FEATURES) {
            return this.features(features);
        }
        return this.features(ObjectArrays.concat(this.featuresAsEnums(), features, Feature.class));
    }

    @Deprecated
    public GetIndexRequest addFeatures(String[] featureNames) {
        this.addFeatures(Feature.convertToFeatures(featureNames));
        return this;
    }

    @Deprecated
    public String[] features() {
        String[] featureNames = new String[this.features.length];
        for (int i = 0; i < this.features.length; ++i) {
            featureNames[i] = this.features[i].preferredName();
        }
        return featureNames;
    }

    public Feature[] featuresAsEnums() {
        return this.features;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_1_4_1)) {
            Feature.convertToFeatures(in.readStringArray());
        } else {
            int size = in.readVInt();
            this.features = new Feature[size];
            for (int i = 0; i < size; ++i) {
                this.features[i] = Feature.fromId(in.readByte());
            }
        }
        this.indicesOptionsSet = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_4_1)) {
            String[] featureNames = new String[this.features.length];
            for (int i = 0; i < this.features.length; ++i) {
                featureNames[i] = this.features[i].preferredName();
            }
            out.writeStringArray(featureNames);
        } else {
            out.writeVInt(this.features.length);
            for (Feature feature : this.features) {
                out.writeByte(feature.id);
            }
        }
        out.writeBoolean(this.indicesOptionsSet);
    }

    @Override
    public GetIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptionsSet = true;
        return (GetIndexRequest)super.indicesOptions(indicesOptions);
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (!this.indicesOptionsSet) {
            this.indicesOptions(this.resolveIndicesOptions());
        }
        IndicesOptions indicesOptions = super.indicesOptions();
        return indicesOptions;
    }

    private IndicesOptions resolveIndicesOptions() {
        IndicesOptions defaultIndicesOptions = IndicesOptions.strictExpandOpen();
        String[] indices = this.indices();
        if (this.features != null && this.features.length == 1 && this.features[0] != null && Feature.ALIASES.equals((Object)this.features[0])) {
            defaultIndicesOptions = MetaData.isAllIndices(indices) ? IndicesOptions.fromOptions(true, true, true, true) : IndicesOptions.lenientExpandOpen();
        }
        return defaultIndicesOptions;
    }

    public static final class Feature
    extends Enum<Feature> {
        public static final /* enum */ Feature ALIASES = new Feature(0, "_aliases", "_alias");
        public static final /* enum */ Feature MAPPINGS = new Feature(1, "_mappings", "_mapping");
        public static final /* enum */ Feature SETTINGS = new Feature(2, "_settings");
        public static final /* enum */ Feature WARMERS = new Feature(3, "_warmers", "_warmer");
        private static final Feature[] FEATURES;
        private final List<String> validNames;
        private final String preferredName;
        private final byte id;
        private static final /* synthetic */ Feature[] $VALUES;

        public static Feature[] values() {
            return (Feature[])$VALUES.clone();
        }

        public static Feature valueOf(String name) {
            return Enum.valueOf(Feature.class, name);
        }

        private Feature(byte id, String ... validNames) {
            assert (validNames != null && validNames.length > 0);
            this.id = id;
            this.validNames = Arrays.asList(validNames);
            this.preferredName = validNames[0];
        }

        public byte id() {
            return this.id;
        }

        public String preferredName() {
            return this.preferredName;
        }

        public boolean validName(String name) {
            return this.validNames.contains(name);
        }

        public static Feature fromName(String name) throws ElasticsearchIllegalArgumentException {
            for (Feature feature : Feature.values()) {
                if (!feature.validName(name)) continue;
                return feature;
            }
            throw new ElasticsearchIllegalArgumentException("No feature for name [" + name + "]");
        }

        public static Feature fromId(byte id) throws ElasticsearchIllegalArgumentException {
            if (id < 0 || id >= FEATURES.length) {
                throw new ElasticsearchIllegalArgumentException("No mapping for id [" + id + "]");
            }
            return FEATURES[id];
        }

        public static Feature[] convertToFeatures(String ... featureNames) {
            Feature[] features = new Feature[featureNames.length];
            for (int i = 0; i < featureNames.length; ++i) {
                features[i] = Feature.fromName(featureNames[i]);
            }
            return features;
        }

        static {
            $VALUES = new Feature[]{ALIASES, MAPPINGS, SETTINGS, WARMERS};
            FEATURES = new Feature[Feature.values().length];
            for (Feature feature : Feature.values()) {
                assert (feature.id() < FEATURES.length && feature.id() >= 0);
                Feature.FEATURES[feature.id] = feature;
            }
        }
    }
}

