/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportMasterNodeReadOperationAction<ClusterHealthRequest, ClusterHealthResponse> {
    private final ClusterName clusterName;

    @Inject
    public TransportClusterHealthAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ClusterName clusterName, ActionFilters actionFilters) {
        super(settings, "cluster:monitor/health", transportService, clusterService, threadPool, actionFilters);
        this.clusterName = clusterName;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterHealthRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected ClusterHealthRequest newRequest() {
        return new ClusterHealthRequest();
    }

    @Override
    protected ClusterHealthResponse newResponse() {
        return new ClusterHealthResponse();
    }

    @Override
    protected void masterOperation(final ClusterHealthRequest request, ClusterState unusedState, final ActionListener<ClusterHealthResponse> listener) throws ElasticsearchException {
        if (request.waitForEvents() != null) {
            final long endTime = System.currentTimeMillis() + request.timeout().millis();
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + request.waitForEvents() + "])", request.waitForEvents(), new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTime - System.currentTimeMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis(timeoutInMillis);
                    request.timeout(newTimeout);
                    TransportClusterHealthAction.this.executeHealth(request, listener);
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    TransportClusterHealthAction.this.logger.error("unexpected failure during [{}]", t, source);
                    listener.onFailure(t);
                }

                @Override
                public boolean runOnlyOnMaster() {
                    return !request.local();
                }
            });
        } else {
            this.executeHealth(request, listener);
        }
    }

    private void executeHealth(final ClusterHealthRequest request, final ActionListener<ClusterHealthResponse> listener) {
        int waitFor = 5;
        if (request.waitForStatus() == null) {
            --waitFor;
        }
        if (request.waitForRelocatingShards() == -1) {
            --waitFor;
        }
        if (request.waitForActiveShards() == -1) {
            --waitFor;
        }
        if (request.waitForNodes().isEmpty()) {
            --waitFor;
        }
        if (request.indices().length == 0) {
            --waitFor;
        }
        assert (waitFor >= 0);
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, this.logger);
        ClusterState state = observer.observedState();
        if (waitFor == 0 || request.timeout().millis() == 0L) {
            listener.onResponse(this.getResponse(request, state, waitFor, request.timeout().millis() == 0L));
            return;
        }
        final int concreteWaitFor = waitFor;
        ClusterStateObserver.ValidationPredicate validationPredicate = new ClusterStateObserver.ValidationPredicate(){

            @Override
            protected boolean validate(ClusterState newState) {
                return newState.status() == ClusterState.ClusterStateStatus.APPLIED && TransportClusterHealthAction.this.validateRequest(request, newState, concreteWaitFor);
            }
        };
        ClusterStateObserver.Listener stateListener = new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState clusterState) {
                listener.onResponse(TransportClusterHealthAction.this.getResponse(request, clusterState, concreteWaitFor, false));
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new ElasticsearchIllegalStateException("ClusterService was close during health call"));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                ClusterState clusterState = TransportClusterHealthAction.this.clusterService.state();
                ClusterHealthResponse response = TransportClusterHealthAction.this.getResponse(request, clusterState, concreteWaitFor, true);
                listener.onResponse(response);
            }
        };
        if (state.status() == ClusterState.ClusterStateStatus.APPLIED && this.validateRequest(request, state, concreteWaitFor)) {
            stateListener.onNewClusterState(state);
        } else {
            observer.waitForNextChange(stateListener, validationPredicate, request.timeout());
        }
    }

    private boolean validateRequest(ClusterHealthRequest request, ClusterState clusterState, int waitFor) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.numberOfPendingTasks());
        return this.prepareResponse(request, response, clusterState, waitFor);
    }

    private ClusterHealthResponse getResponse(ClusterHealthRequest request, ClusterState clusterState, int waitFor, boolean timedOut) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.numberOfPendingTasks());
        boolean valid = this.prepareResponse(request, response, clusterState, waitFor);
        assert (valid || timedOut);
        response.timedOut = timedOut && !valid;
        return response;
    }

    private boolean prepareResponse(ClusterHealthRequest request, ClusterHealthResponse response, ClusterState clusterState, int waitFor) {
        int waitForCounter = 0;
        if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
            ++waitForCounter;
        }
        if (request.waitForRelocatingShards() != -1 && response.getRelocatingShards() <= request.waitForRelocatingShards()) {
            ++waitForCounter;
        }
        if (request.waitForActiveShards() != -1 && response.getActiveShards() >= request.waitForActiveShards()) {
            ++waitForCounter;
        }
        if (request.indices().length > 0) {
            try {
                clusterState.metaData().concreteIndices(IndicesOptions.strictExpand(), request.indices());
                ++waitForCounter;
            }
            catch (IndexMissingException e) {
                response.status = ClusterHealthStatus.RED;
            }
        }
        if (!request.waitForNodes().isEmpty()) {
            if (request.waitForNodes().startsWith(">=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("ge(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("le(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith(">")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("gt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("lt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else {
                int expected = Integer.parseInt(request.waitForNodes());
                if (response.getNumberOfNodes() == expected) {
                    ++waitForCounter;
                }
            }
        }
        return waitForCounter == waitFor;
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState, int numberOfPendingTasks) {
        String[] concreteIndices;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Calculating health based on state version [{}]", clusterState.version());
        }
        try {
            concreteIndices = clusterState.metaData().concreteIndices(request.indicesOptions(), request.indices());
        }
        catch (IndexMissingException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(this.clusterName.value(), Strings.EMPTY_ARRAY, clusterState, numberOfPendingTasks);
            response.status = ClusterHealthStatus.RED;
            return response;
        }
        return new ClusterHealthResponse(this.clusterName.value(), concreteIndices, clusterState, numberOfPendingTasks);
    }
}

