/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import org.openjena.atlas.lib.Lib;

public abstract class ExprFunction1
extends ExprFunction {
    protected final Expr expr;

    protected ExprFunction1(Expr expr, String fName) {
        this(expr, fName, null);
    }

    protected ExprFunction1(Expr expr, String fName, String opSign) {
        super(fName, opSign);
        this.expr = expr;
    }

    public Expr getArg() {
        return this.expr;
    }

    public Expr getArg(int i) {
        if (i == 1) {
            return this.expr;
        }
        return null;
    }

    public int hashCode() {
        return this.getFunctionSymbol().hashCode() ^ Lib.hashCodeObject(this.expr);
    }

    public int numArgs() {
        return 1;
    }

    public final NodeValue eval(Binding binding, FunctionEnv env) {
        NodeValue s = this.evalSpecial(binding, env);
        if (s != null) {
            return s;
        }
        NodeValue x = ExprFunction1.eval(binding, env, this.expr);
        return this.eval(x, env);
    }

    public NodeValue eval(NodeValue v, FunctionEnv env) {
        return this.eval(v);
    }

    public abstract NodeValue eval(NodeValue var1);

    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        return null;
    }

    public final Expr copySubstitute(Binding binding, boolean foldConstants) {
        Expr e2;
        Expr expr = e2 = this.expr == null ? null : this.expr.copySubstitute(binding, foldConstants);
        if (foldConstants) {
            try {
                if (e2 != null && e2.isConstant()) {
                    return this.eval(e2.getConstant(), (FunctionEnv)new FunctionEnvBase());
                }
            }
            catch (ExprEvalException ex) {
                // empty catch block
            }
        }
        return this.copy(e2);
    }

    public final Expr applyNodeTransform(NodeTransform transform) {
        Expr e2 = this.expr == null ? null : this.expr.applyNodeTransform(transform);
        return this.copy(e2);
    }

    public abstract Expr copy(Expr var1);

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform, Expr sub) {
        return transform.transform(this, sub);
    }
}

