/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.AbstractUMObject;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.UserRootObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;

@WebObject(type="user")
@Produces(value={"application/json", "application/json+nxentity"})
public class UserObject
extends AbstractUMObject<NuxeoPrincipal> {
    @Path(value="group/{groupName}")
    public Object doGetUserToGroup(@PathParam(value="groupName") String groupName) {
        try {
            NuxeoGroup group = this.um.getGroup(groupName);
            if (group == null) {
                throw new WebResourceNotFoundException("Group not found");
            }
            return this.newObject("userToGroup", new Object[]{this.currentArtifact, group});
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Override
    protected NuxeoPrincipal updateArtifact(NuxeoPrincipal principal) {
        this.um.updateUser(principal.getModel());
        return this.um.getPrincipal(principal.getName());
    }

    @Override
    protected void deleteArtifact() {
        this.um.deleteUser(((NuxeoPrincipal)this.currentArtifact).getModel());
    }

    @Override
    protected boolean isAPowerUserEditableArtifact() {
        return UserRootObject.isAPowerUserEditableUser((NuxeoPrincipal)this.currentArtifact);
    }
}

