/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import java.io.Serializable;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.AbstractUMObject;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.GroupRootObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="group")
public class GroupObject
extends AbstractUMObject<NuxeoGroup> {
    @Path(value="user/{username}")
    public Object doGetUserToGroup(@PathParam(value="username") String username) {
        try {
            UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
            NuxeoPrincipal principal = um.getPrincipal(username);
            if (principal == null) {
                throw new WebResourceNotFoundException("User not found");
            }
            return this.newObject("userToGroup", new Object[]{principal, this.currentArtifact});
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Override
    protected NuxeoGroup updateArtifact(NuxeoGroup updateGroup) {
        DocumentModel groupModel = this.um.getGroupModel(((NuxeoGroup)this.currentArtifact).getName());
        groupModel.setPropertyValue(this.um.getGroupLabelField(), (Serializable)((Object)updateGroup.getLabel()));
        groupModel.setPropertyValue(this.um.getGroupMembersField(), (Serializable)((Object)updateGroup.getMemberUsers()));
        groupModel.setPropertyValue(this.um.getGroupSubGroupsField(), (Serializable)((Object)updateGroup.getMemberGroups()));
        this.um.updateGroup(groupModel);
        return this.um.getGroup(((NuxeoGroup)this.currentArtifact).getName());
    }

    @Override
    protected void deleteArtifact() {
        this.um.deleteGroup(this.um.getGroupModel(((NuxeoGroup)this.currentArtifact).getName()));
    }

    @Override
    protected boolean isAPowerUserEditableArtifact() {
        return GroupRootObject.isAPowerUserEditableGroup((NuxeoGroup)this.currentArtifact);
    }
}

