/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.conversion;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConversionStatus;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="conversions")
public class ConversionRootObject
extends DefaultObject {
    @GET
    @Path(value="{id}/poll")
    public Object doGetConversionStatus(@PathParam(value="id") String id) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        ConversionStatus conversionStatus = conversionService.getConversionStatus(id);
        if (conversionStatus == null) {
            throw new WebResourceNotFoundException("No conversion job for id: " + id);
        }
        if (conversionStatus.status == ConversionStatus.Status.COMPLETED) {
            String serverURL = this.ctx.getServerURL().toString();
            if (serverURL.endsWith("/")) {
                serverURL = serverURL.substring(0, serverURL.length() - 1);
            }
            String url = String.format("%s%s/conversions/%s/result", serverURL, this.ctx.getModulePath(), id);
            try {
                return Response.seeOther((URI)new URI(url)).build();
            }
            catch (URISyntaxException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return Response.ok((Object)conversionStatus).build();
    }

    @GET
    @Path(value="{id}/result")
    public Object doGetConversionResult(@PathParam(value="id") String id) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = conversionService.getConversionResult(id, false);
        if (result == null || result.getBlob() == null) {
            throw new WebResourceNotFoundException("No conversion result for id: " + id);
        }
        return result.getBlob();
    }
}

