/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.permissions.PermissionHelper;
import org.nuxeo.ecm.permissions.TransientUserPermissionHelper;
import org.nuxeo.runtime.api.Framework;

public class PermissionListener
implements EventListener {
    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        if ("documentSecurityUpdated".equals(event.getName())) {
            this.updateDirectory((DocumentEventContext)ctx);
        }
    }

    protected void updateDirectory(DocumentEventContext docCtx) {
        ACP oldACP = (ACP)docCtx.getProperty("oldACP");
        ACP newACP = (ACP)docCtx.getProperty("newACP");
        if (oldACP != null && newACP != null) {
            this.handleUpdateACP(docCtx, oldACP, newACP);
        }
    }

    protected void handleUpdateACP(DocumentEventContext docCtx, ACP oldACP, ACP newACP) {
        DocumentModel doc = docCtx.getSourceDocument();
        List<ACLDiff> aclDiffs = this.extractACLDiffs(oldACP, newACP);
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        for (ACLDiff diff : aclDiffs) {
            Session session = directoryService.open("aceinfo");
            Throwable throwable = null;
            try {
                String id;
                for (ACE ace : diff.removedACEs) {
                    id = PermissionHelper.computeDirectoryId(doc, diff.aclName, ace.getId());
                    session.deleteEntry(id);
                    this.removeToken(doc, ace);
                }
                for (ACE ace : diff.addedACEs) {
                    id = PermissionHelper.computeDirectoryId(doc, diff.aclName, ace.getId());
                    if (session.hasEntry(id)) {
                        session.deleteEntry(id);
                    }
                    Boolean notify = (Boolean)ace.getContextData("notify");
                    String comment = (String)((Object)ace.getContextData("comment"));
                    notify = notify != null ? notify : false;
                    Map<String, Object> m = PermissionHelper.createDirectoryEntry(doc, diff.aclName, ace, notify, comment);
                    session.createEntry(m);
                    this.addToken(doc, ace);
                    if (!notify.booleanValue() || !ace.isGranted() || !ace.isEffective()) continue;
                    this.firePermissionNotificationEvent(docCtx, diff.aclName, ace);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
    }

    @Deprecated
    protected void handleReplaceACE(DocumentEventContext docCtx, String changedACLName, ACE oldACE, ACE newACE) {
        DocumentModel doc = docCtx.getSourceDocument();
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try (Session session = directoryService.open("aceinfo");){
            Boolean notify = (Boolean)newACE.getContextData("notify");
            String comment = (String)((Object)newACE.getContextData("comment"));
            String oldId = PermissionHelper.computeDirectoryId(doc, changedACLName, oldACE.getId());
            DocumentModel oldEntry = session.getEntry(oldId);
            if (oldEntry != null) {
                session.deleteEntry(oldId);
            }
            notify = notify != null ? notify : false;
            Map<String, Object> m = PermissionHelper.createDirectoryEntry(doc, changedACLName, newACE, notify, comment);
            session.createEntry(m);
            if (notify.booleanValue() && newACE.isGranted() && newACE.isEffective()) {
                this.firePermissionNotificationEvent(docCtx, changedACLName, newACE);
            }
        }
    }

    protected List<ACLDiff> extractACLDiffs(ACP oldACP, ACP newACP) {
        ArrayList<ACLDiff> aclDiffs = new ArrayList<ACLDiff>();
        List<String> oldACLNames = this.toACLNames(oldACP);
        List<String> newACLNames = this.toACLNames(newACP);
        List<String> addedACLNames = this.toACLNames(newACP);
        List<String> removedACLNames = this.toACLNames(oldACP);
        addedACLNames.removeAll(oldACLNames);
        removedACLNames.removeAll(newACLNames);
        for (String name : addedACLNames) {
            aclDiffs.add(new ACLDiff(name, new ArrayList(newACP.getACL(name)), null));
        }
        for (String name : removedACLNames) {
            aclDiffs.add(new ACLDiff(name, null, new ArrayList(oldACP.getACL(name))));
        }
        for (ACL newACL : newACP.getACLs()) {
            ACL oldACL = oldACP.getACL(newACL.getName());
            if (oldACL == null) continue;
            ArrayList addedACEs = new ArrayList(newACL);
            ArrayList removedACEs = new ArrayList(oldACL);
            addedACEs.removeAll((Collection<?>)oldACL);
            removedACEs.removeAll((Collection<?>)newACL);
            aclDiffs.add(new ACLDiff(newACL.getName(), addedACEs, removedACEs));
        }
        return aclDiffs;
    }

    protected List<String> toACLNames(ACP acp) {
        ArrayList<String> aclNames = new ArrayList<String>();
        for (ACL acl : acp.getACLs()) {
            aclNames.add(acl.getName());
        }
        return aclNames;
    }

    protected void firePermissionNotificationEvent(DocumentEventContext docCtx, String aclName, ACE ace) {
        docCtx.setProperty("ace", (Serializable)ace);
        docCtx.setProperty("aclName", (Serializable)((Object)aclName));
        EventService eventService = (EventService)Framework.getService(EventService.class);
        eventService.fireEvent("permissionNotification", (EventContext)docCtx);
    }

    protected void addToken(DocumentModel doc, ACE ace) {
        if (!ace.isArchived()) {
            TransientUserPermissionHelper.acquireToken(ace.getUsername(), doc, ace.getPermission());
        }
    }

    protected void removeToken(DocumentModel doc, ACE deletedAce) {
        TransientUserPermissionHelper.revokeToken(deletedAce.getUsername(), doc);
    }

    private static class ACLDiff {
        public final String aclName;
        public final List<ACE> addedACEs;
        public final List<ACE> removedACEs;

        private ACLDiff(String aclName, List<ACE> addedACEs, List<ACE> removedACEs) {
            this.aclName = aclName;
            this.addedACEs = addedACEs != null ? addedACEs : Collections.emptyList();
            this.removedACEs = removedACEs != null ? removedACEs : Collections.emptyList();
        }
    }
}

