/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionTypeInfo2Entry;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptionTypeInfo2Decoder {
    public EncryptionTypeInfo2Entry[] decode(byte[] encodedEntries) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedEntries);
        DERSequence sequence = (DERSequence)ais.readObject();
        return EncryptionTypeInfo2Decoder.decodeSequence(sequence);
    }

    protected static EncryptionTypeInfo2Entry[] decodeSequence(DERSequence sequence) {
        EncryptionTypeInfo2Entry[] entrySequence = new EncryptionTypeInfo2Entry[sequence.size()];
        int ii = 0;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERSequence object = (DERSequence)e.nextElement();
            entrySequence[ii] = EncryptionTypeInfo2Decoder.decode(object);
            ++ii;
        }
        return entrySequence;
    }

    protected static EncryptionTypeInfo2Entry decode(DERSequence sequence) {
        EncryptionType encryptionType = EncryptionType.NULL;
        String salt = new String();
        byte[] s2kparams = new byte[]{};
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    encryptionType = EncryptionType.getTypeByOrdinal(tag0.intValue());
                    break;
                }
                case 1: {
                    DERGeneralString tag1 = (DERGeneralString)derObject;
                    salt = tag1.getString();
                    break;
                }
                case 2: {
                    DEROctetString tag2 = (DEROctetString)derObject;
                    s2kparams = tag2.getOctets();
                }
            }
        }
        return new EncryptionTypeInfo2Entry(encryptionType, salt, s2kparams);
    }
}

