/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.data.CacheHeaderContentStream;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentLengthContentStream;
import org.apache.chemistry.opencmis.commons.data.LastModifiedContentStream;
import org.apache.chemistry.opencmis.commons.data.RedirectingContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;

public class NuxeoContentStream
implements CacheHeaderContentStream,
LastModifiedContentStream,
ContentLengthContentStream {
    public static long LAST_MODIFIED;
    protected final Blob blob;
    protected final GregorianCalendar lastModified;
    protected final InputStream stream;

    private NuxeoContentStream(Blob blob, GregorianCalendar lastModified) {
        this.blob = blob;
        this.lastModified = lastModified;
        this.stream = new LazyInputStream(this::getActualStream);
    }

    public static NuxeoContentStream create(DocumentModel doc, String xpath, Blob blob, String reason, Map<String, Serializable> extendedInfos, GregorianCalendar lastModified, HttpServletRequest request) {
        URI uri;
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        try {
            uri = blobManager.getURI(blob, BlobManager.UsageHint.DOWNLOAD, request);
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Failed to get download URI", (Throwable)e);
        }
        if (uri != null) {
            extendedInfos = new HashMap<String, Serializable>(extendedInfos == null ? Collections.emptyMap() : extendedInfos);
            extendedInfos.put("redirect", (Serializable)((Object)uri.toString()));
        }
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        downloadService.logDownload(doc, xpath, blob.getFilename(), reason, extendedInfos);
        if (uri == null) {
            return new NuxeoContentStream(blob, lastModified);
        }
        return new NuxeoRedirectingContentStream(blob, lastModified, uri.toString());
    }

    public long getLength() {
        return this.blob.getLength();
    }

    public BigInteger getBigLength() {
        return BigInteger.valueOf(this.blob.getLength());
    }

    public String getMimeType() {
        return this.blob.getMimeType();
    }

    public String getFileName() {
        return this.blob.getFilename();
    }

    public InputStream getStream() {
        return this.stream;
    }

    protected InputStream getActualStream() {
        try {
            return this.blob.getStream();
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Failed to get stream", (Throwable)e);
        }
    }

    public List<CmisExtensionElement> getExtensions() {
        return null;
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
        throw new UnsupportedOperationException();
    }

    public String getCacheControl() {
        return null;
    }

    public String getETag() {
        return this.blob.getDigest();
    }

    public GregorianCalendar getExpires() {
        return null;
    }

    public GregorianCalendar getLastModified() {
        LAST_MODIFIED = this.lastModified == null ? 0L : this.lastModified.getTimeInMillis();
        return this.lastModified;
    }

    public static class NuxeoRedirectingContentStream
    extends NuxeoContentStream
    implements RedirectingContentStream {
        protected final String location;

        private NuxeoRedirectingContentStream(Blob blob, GregorianCalendar lastModified, String location) {
            super(blob, lastModified);
            this.location = location;
        }

        public int getStatus() {
            return 302;
        }

        public String getLocation() {
            return this.location;
        }
    }

    public static class LazyInputStream
    extends ProxyInputStream {
        protected Supplier<InputStream> supplier;

        public LazyInputStream(Supplier<InputStream> supplier) {
            super(null);
            this.supplier = supplier;
        }

        protected void beforeRead(int n) {
            if (this.in == null) {
                this.in = this.supplier.get();
                this.supplier = null;
            }
        }

        public void close() throws IOException {
            if (this.in == null) {
                this.in = new ClosedInputStream();
                this.supplier = null;
                return;
            }
            super.close();
        }

        public long skip(long ln) throws IOException {
            this.beforeRead(0);
            return super.skip(ln);
        }

        public int available() throws IOException {
            this.beforeRead(0);
            return super.available();
        }

        public void mark(int readlimit) {
            this.beforeRead(0);
            super.mark(readlimit);
        }

        public void reset() throws IOException {
            this.beforeRead(0);
            super.reset();
        }

        public boolean markSupported() {
            this.beforeRead(0);
            return super.markSupported();
        }
    }
}

