/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.server;

import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.helper.VersioningHelper;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.ExtendedDocumentLocation;

public class ExternalCorePublishedDocument
implements PublishedDocument {
    private static final long serialVersionUID = 1L;
    protected String sourceServer;
    protected String repositoryName;
    protected DocumentRef ref;
    protected String versionLabel;
    protected String path;
    protected String parentPath;
    protected boolean isPending;

    public ExternalCorePublishedDocument(DocumentModel doc) {
        ExtendedDocumentLocation xLoc = ExtendedDocumentLocation.extractFromDoc(doc);
        this.sourceServer = xLoc.getOriginalServer();
        this.repositoryName = xLoc.getServerName();
        this.ref = xLoc.getDocRef();
        this.versionLabel = VersioningHelper.getVersionLabelFor(doc);
        Path p = doc.getPath();
        this.path = p.toString();
        this.parentPath = p.removeLastSegments(1).toString();
    }

    public DocumentRef getSourceDocumentRef() {
        return this.ref;
    }

    public String getSourceRepositoryName() {
        return this.repositoryName;
    }

    public String getSourceServer() {
        return this.sourceServer;
    }

    public String getSourceVersionLabel() {
        return this.versionLabel;
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public PublishedDocument.Type getType() {
        return PublishedDocument.Type.REMOTE;
    }
}

