/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling.basic;

import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;

public class BasicPublicationNode
implements PublicationNode {
    private static final long serialVersionUID = 1L;
    protected String nodeType;
    protected String nodePath;
    protected String nodeTitle;
    protected String treeName;
    protected String sid;

    public BasicPublicationNode(String nodeType, String nodePath, String nodeTitle, String treeName) {
        this(nodeType, nodePath, nodeTitle, treeName, null);
    }

    public BasicPublicationNode(String nodeType, String nodePath, String nodeTitle, String treeName, String sid) {
        this.nodePath = nodePath;
        this.nodeType = nodeType;
        this.nodeTitle = nodeTitle;
        this.treeName = treeName;
        this.sid = sid;
    }

    public List<PublishedDocument> getChildrenDocuments() {
        throw new NuxeoException("Can not be called on a remote node");
    }

    public List<PublicationNode> getChildrenNodes() {
        throw new NuxeoException("Can not be called on a remote node");
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public PublicationNode getParent() {
        return null;
    }

    public String getPath() {
        return this.nodePath;
    }

    public String getTitle() {
        return this.nodeTitle;
    }

    public String getName() {
        if (this.nodePath == null) {
            return null;
        }
        return new Path(this.nodePath).lastSegment();
    }

    public String getTreeConfigName() {
        return this.treeName;
    }

    public String getSessionId() {
        return this.sid;
    }

    public String getType() {
        return this.getClass().getSimpleName();
    }
}

