/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.relations.api.DocumentRelationManager;

@Operation(id="Document.DeleteRelation", category="Services", label="Delete Relation", description="Delete a relation between 2 documents. The subject of the relation will be the input of the operation and the object of the relation will be retrieved from the context using the 'object' field. The 'predicate' field specifies the relation predicate (When using a known predicate, use the full URL like 'purl.org/dc/terms/IsBasedOn', unknown predicates will be treated as plain strings and be the same on the subject and object). The 'outgoing' flag indicates the direction of the relation - the default is false which means the relation will go from the input object to the object specified as 'object' parameter. Return back the subject document.", aliases={"Relations.DeleteRelation"})
public class DeleteRelation {
    public static final String ID = "Document.DeleteRelation";
    @Context
    protected CoreSession session;
    @Context
    protected DocumentRelationManager relations;
    @Param(name="object")
    protected DocumentModel object;
    @Param(name="predicate")
    protected String predicate;
    @Param(name="outgoing", required=false, values={"false"})
    protected boolean outgoing = false;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.relations.deleteRelation(this.session, doc, this.object, this.predicate, this.outgoing);
        return doc;
    }
}

