/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageEntry
implements Serializable {
    protected Log log = LogFactory.getLog(StorageEntry.class);
    private static final long serialVersionUID = 1L;
    protected ConcurrentMap<String, Serializable> params = null;
    protected List<Map<String, String>> blobInfos = null;
    protected long size;
    protected boolean completed;

    public StorageEntry() {
        this(0L, false);
    }

    public StorageEntry(long size, boolean completed) {
        this.size = size;
        this.completed = completed;
    }

    public Map<String, Serializable> getParams() {
        if (this.params == null) {
            this.params = new ConcurrentHashMap<String, Serializable>();
        }
        return this.params;
    }

    public void putParams(Map<String, Serializable> params) {
        if (this.params == null) {
            this.params = new ConcurrentHashMap<String, Serializable>();
        }
        this.params.putAll(params);
    }

    public Serializable getParam(String param) {
        if (this.params == null) {
            return null;
        }
        return (Serializable)this.params.get(param);
    }

    public void putParam(String param, Serializable value) {
        if (this.params == null) {
            this.params = new ConcurrentHashMap<String, Serializable>();
        }
        this.params.put(param, value);
    }

    public List<Map<String, String>> getBlobInfos() {
        return this.blobInfos;
    }

    public void setBlobInfos(List<Map<String, String>> blobInfos) {
        this.blobInfos = blobInfos;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }
}

