/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.ExpandingVisitor;
import org.apache.directory.server.core.normalization.NormalizingVisitor;
import org.apache.directory.server.core.normalization.UndefinedFilterAttributeException;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.EmptyEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(NormalizationService.class);
    private NormalizingVisitor normVisitor;
    private ExpandingVisitor expVisitor;
    private AttributeTypeRegistry attributeRegistry;
    private Map<String, OidNormalizer> attrNormalizers;

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        OidRegistry oidRegistry = factoryCfg.getRegistries().getOidRegistry();
        this.attributeRegistry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.attributeRegistry, oidRegistry);
        this.normVisitor = new NormalizingVisitor((NameComponentNormalizer)ncn, oidRegistry);
        this.expVisitor = new ExpandingVisitor(this.attributeRegistry);
        this.attrNormalizers = this.attributeRegistry.getNormalizerMapping();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        nextInterceptor.add(opContext);
    }

    @Override
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        nextInterceptor.delete(opContext);
    }

    @Override
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        nextInterceptor.modify(opContext);
    }

    @Override
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        nextInterceptor.rename(opContext);
    }

    @Override
    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        opContext.getParent().normalize(this.attrNormalizers);
        nextInterceptor.move(opContext);
    }

    @Override
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        LdapDN.normalize((LdapDN)opContext.getParent(), this.attrNormalizers);
        nextInterceptor.moveAndRename(opContext);
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws NamingException {
        BranchNode bnode;
        LeafNode ln;
        LdapDN base = opContext.getDn();
        ExprNode filter = opContext.getFilter();
        base.normalize(this.attrNormalizers);
        if (filter.isLeaf() && !this.attributeRegistry.hasAttributeType((ln = (LeafNode)filter).getAttribute())) {
            StringBuffer buf = new StringBuffer();
            buf.append("undefined filter based on undefined attributeType '");
            buf.append(ln.getAttribute());
            buf.append("' not evaluted at all.  Returning empty enumeration.");
            log.warn(buf.toString());
            return new EmptyEnumeration();
        }
        boolean isFailure = true;
        while (isFailure && filter != null) {
            try {
                LeafNode ln2;
                if (filter.isLeaf() && !this.attributeRegistry.hasAttributeType((ln2 = (LeafNode)filter).getAttribute())) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("undefined filter based on undefined attributeType '");
                    buf.append(ln2.getAttribute());
                    buf.append("' not evaluted at all.  Returning empty enumeration.");
                    log.warn(buf.toString());
                    return new EmptyEnumeration();
                }
                filter.accept((FilterVisitor)this.normVisitor);
                isFailure = false;
            }
            catch (UndefinedFilterAttributeException e) {
                isFailure = true;
                if (log.isWarnEnabled()) {
                    log.warn("An undefined attribute was found within the supplied search filter.  The node associated with the filter has been removed.", e.getCause());
                }
                if ((bnode = (BranchNode)filter).isNegation()) {
                    return new EmptyEnumeration();
                }
                bnode.getChildren().remove(e.getUndefinedFilterNode());
                if (bnode.getOperator() == AssertionEnum.AND) {
                    return new EmptyEnumeration();
                }
                if (bnode.getChildren().size() >= 2) continue;
                filter = bnode.getChild();
            }
        }
        if (!filter.isLeaf()) {
            BranchNode child = (BranchNode)filter;
            if (child.getChildren().size() == 0 || child.get((Object)"undefined") == Boolean.TRUE) {
                log.warn("Undefined branchnode filter without child nodes not evaluted at all.  Returning empty enumeration.");
                return new EmptyEnumeration();
            }
            if (child.getChildren().size() == 1 && child.getOperator() != AssertionEnum.NOT) {
                filter = child.getChild();
            }
        }
        if (!filter.isLeaf()) {
            this.expVisitor.visit(filter);
        } else {
            LeafNode leaf = (LeafNode)filter;
            if (this.attributeRegistry.hasDescendants(leaf.getAttribute())) {
                bnode = new BranchNode(AssertionEnum.OR);
                bnode.getChildren().add(filter);
                filter = bnode;
                Iterator descendants = this.attributeRegistry.descendants(leaf.getAttribute());
                while (descendants.hasNext()) {
                    PresenceNode newLeaf = null;
                    AttributeType descendant = (AttributeType)descendants.next();
                    switch (leaf.getAssertionType()) {
                        case EXTENSIBLE: {
                            ExtensibleNode extensibleNode = (ExtensibleNode)leaf;
                            newLeaf = new ExtensibleNode(descendant.getOid(), extensibleNode.getValue(), extensibleNode.getMatchingRuleId(), extensibleNode.dnAttributes());
                            break;
                        }
                        case PRESENCE: {
                            newLeaf = new PresenceNode(descendant.getOid());
                            break;
                        }
                        case SUBSTRING: {
                            SubstringNode substringNode = (SubstringNode)leaf;
                            newLeaf = new SubstringNode(descendant.getOid(), substringNode.getInitial(), substringNode.getFinal());
                            break;
                        }
                        case APPROXIMATE: 
                        case EQUALITY: 
                        case GREATEREQ: 
                        case LESSEQ: {
                            SimpleNode simpleNode = (SimpleNode)leaf;
                            if (simpleNode.getValue() instanceof String) {
                                newLeaf = new SimpleNode(descendant.getOid(), (String)simpleNode.getValue(), simpleNode.getAssertionType());
                                break;
                            }
                            if (simpleNode.getValue() instanceof byte[]) {
                                newLeaf = new SimpleNode(descendant.getOid(), (byte[])simpleNode.getValue(), simpleNode.getAssertionType());
                                break;
                            }
                            newLeaf = new SimpleNode(descendant.getOid(), simpleNode.getValue().toString(), simpleNode.getAssertionType());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown assertion type: " + leaf.getAssertionType());
                        }
                    }
                    bnode.getChildren().add(newLeaf);
                }
            }
        }
        opContext.setFilter(filter);
        return nextInterceptor.search(opContext);
    }

    @Override
    public boolean hasEntry(NextInterceptor nextInterceptor, EntryOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        return nextInterceptor.hasEntry(opContext);
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        return nextInterceptor.list(opContext);
    }

    @Override
    public Attributes lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        return nextInterceptor.lookup(opContext);
    }

    @Override
    public LdapDN getMatchedName(NextInterceptor nextInterceptor, GetMatchedNameOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        return nextInterceptor.getMatchedName(opContext);
    }

    @Override
    public LdapDN getSuffix(NextInterceptor nextInterceptor, GetSuffixOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        return nextInterceptor.getSuffix(opContext);
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        return next.compare(opContext);
    }

    @Override
    public void bind(NextInterceptor next, BindOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        next.bind(opContext);
    }

    @Override
    public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws NamingException {
        next.addContextPartition(opContext);
    }

    @Override
    public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws NamingException {
        LdapDN.normalize((LdapDN)opContext.getDn(), this.attrNormalizers);
        next.removeContextPartition(opContext);
    }
}

