/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.HashMap;
import java.util.Map;
import javax.naming.ldap.Control;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.name.LdapDN;

public abstract class AbstractOperationContext
implements OperationContext {
    private static final Control[] EMPTY_CONTROLS = new Control[0];
    private LdapDN dn;
    private Map<String, Control> requestControls = new HashMap<String, Control>(4);
    private Map<String, Control> responseControls = new HashMap<String, Control>(4);

    public AbstractOperationContext() {
    }

    public AbstractOperationContext(LdapDN dn) {
        this.dn = dn;
    }

    public LdapDN getDn() {
        return this.dn;
    }

    public void setDn(LdapDN dn) {
        this.dn = dn;
    }

    public void addRequestControl(Control requestControl) {
        this.requestControls.put(requestControl.getID(), requestControl);
    }

    public Control getRequestControl(String numericOid) {
        return this.requestControls.get(numericOid);
    }

    public boolean hasRequestControl(String numericOid) {
        return this.requestControls.containsKey(numericOid);
    }

    public void addResponseControl(Control responseControl) {
        this.responseControls.put(responseControl.getID(), responseControl);
    }

    public Control getResponseControl(String numericOid) {
        return this.responseControls.get(numericOid);
    }

    public boolean hasResponseControl(String numericOid) {
        return this.responseControls.containsKey(numericOid);
    }

    public Control[] getResponseControls() {
        if (this.responseControls.isEmpty()) {
            return EMPTY_CONTROLS;
        }
        return this.responseControls.values().toArray(EMPTY_CONTROLS);
    }

    public boolean hasResponseControls() {
        return !this.responseControls.isEmpty();
    }

    public int getResponseControlCount() {
        return this.responseControls.size();
    }

    public void addRequestControls(Control[] requestControls) {
        for (Control c : requestControls) {
            this.requestControls.put(c.getID(), c);
        }
    }
}

