/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.forms.FormInstance;

public class TestFormInstance
implements FormInstance {
    protected final Map<String, String[]> params;
    protected final Map<String, Blob[]> blobs;

    public TestFormInstance(Map<String, String[]> params, Map<String, Blob[]> blobs) {
        this.params = params == null ? new HashMap<String, String[]>() : params;
        this.blobs = blobs == null ? new HashMap<String, Blob[]>() : blobs;
    }

    public TestFormInstance() {
        this(null, null);
    }

    public TestFormInstance(Map<String, String[]> params) {
        this(params, null);
    }

    public void setField(String key, String ... values) {
        this.params.put(key, values);
    }

    public void addField(String key, String ... values) {
        String[] ar = this.params.get(key);
        if (ar == null) {
            this.params.put(key, values);
        } else {
            String[] tmp = new String[ar.length + values.length];
            System.arraycopy(ar, 0, tmp, 0, ar.length);
            System.arraycopy(values, 0, tmp, ar.length, values.length);
            this.params.put(key, tmp);
        }
    }

    public void setField(String key, Blob ... values) {
        this.blobs.put(key, values);
    }

    public void addField(String key, Blob ... values) {
        Blob[] ar = this.blobs.get(key);
        if (this.blobs == null) {
            this.blobs.put(key, values);
        } else {
            Blob[] tmp = new Blob[ar.length + values.length];
            System.arraycopy(ar, 0, tmp, 0, ar.length);
            System.arraycopy(values, 0, tmp, ar.length, values.length);
            this.blobs.put(key, tmp);
        }
    }

    @Override
    public Collection<String> getKeys() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.params.keySet());
        result.addAll(this.blobs.keySet());
        return result;
    }

    @Override
    public void fillDocument(DocumentModel doc) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Object[] get(String key) {
        Object[] val = this.params.get(key);
        if (val == null) {
            val = this.blobs.get(key);
        }
        return val;
    }

    @Override
    public Blob getBlob(String key) {
        Blob[] blobs = this.blobs.get(key);
        return blobs == null ? null : blobs[0];
    }

    @Override
    public Blob[] getBlobs(String key) {
        return this.blobs.get(key);
    }

    @Override
    public Map<String, Blob[]> getBlobFields() {
        return this.blobs;
    }

    @Override
    public Map<String, String[]> getFormFields() {
        return this.params;
    }

    @Override
    public String[] getList(String key) {
        return this.params.get(key);
    }

    @Override
    public String getString(String key) {
        String[] values = this.params.get(key);
        return values == null ? null : values[0];
    }
}

