/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.query.QueryParseException;

public class FulltextQueryAnalyzer {
    protected static final String SPACE = " ";
    protected static final String PLUS = "+";
    protected static final String MINUS = "-";
    protected static final char CSPACE = ' ';
    protected static final String DOUBLE_QUOTES = "\"";
    protected static final String OR = "OR";
    protected static final Pattern SEPARATOR = Pattern.compile("[ ]");
    protected static final Pattern IGNORED = Pattern.compile("\\p{Punct}+");
    protected FulltextQuery ft = new FulltextQuery();
    protected List<FulltextQuery> terms = new LinkedList<FulltextQuery>();

    protected FulltextQuery analyze(String query) {
        if ((query = query.replaceAll(" +", SPACE).trim()).trim().length() == 0) {
            return null;
        }
        this.ft.op = Op.OR;
        this.ft.terms = new LinkedList<FulltextQuery>();
        boolean wasOr = false;
        String[] words = this.split(query);
        Iterator<String> it = Arrays.asList(words).iterator();
        while (it.hasNext()) {
            boolean plus = false;
            boolean minus = false;
            String word = it.next();
            if (this.ignored(word)) continue;
            if (word.startsWith(PLUS)) {
                plus = true;
                word = word.substring(1);
            } else if (word.startsWith(MINUS)) {
                minus = true;
                word = word.substring(1);
            }
            if (word.startsWith(DOUBLE_QUOTES)) {
                word = word.substring(1);
                StringBuilder phrase = null;
                while (true) {
                    boolean end;
                    if (end = word.endsWith(DOUBLE_QUOTES)) {
                        word = word.substring(0, word.length() - 1).trim();
                    }
                    if (word.contains(DOUBLE_QUOTES)) {
                        throw new QueryParseException("Invalid fulltext query (double quotes in word): " + query);
                    }
                    if (word.length() != 0) {
                        if (phrase == null) {
                            phrase = new StringBuilder();
                        } else {
                            phrase.append(' ');
                        }
                        phrase.append(word);
                    }
                    if (end) break;
                    if (!it.hasNext()) {
                        throw new QueryParseException("Invalid fulltext query (unterminated phrase): " + query);
                    }
                    word = it.next();
                }
                if (phrase == null) continue;
                word = phrase.toString();
            } else if (word.equalsIgnoreCase(OR)) {
                if (wasOr) {
                    throw new QueryParseException("Invalid fulltext query (OR OR): " + query);
                }
                if (this.terms.isEmpty()) {
                    throw new QueryParseException("Invalid fulltext query (standalone OR): " + query);
                }
                wasOr = true;
                continue;
            }
            FulltextQuery w = new FulltextQuery();
            if (minus) {
                if (word.length() == 0) {
                    throw new QueryParseException("Invalid fulltext query (standalone -): " + query);
                }
                w.op = Op.NOTWORD;
            } else {
                if (plus && word.length() == 0) {
                    throw new QueryParseException("Invalid fulltext query (standalone +): " + query);
                }
                w.op = Op.WORD;
            }
            if (wasOr) {
                this.endAnd();
                wasOr = false;
            }
            w.word = word;
            this.terms.add(w);
        }
        if (wasOr) {
            throw new QueryParseException("Invalid fulltext query (final OR): " + query);
        }
        this.endAnd();
        int size = this.ft.terms.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            this.ft = this.ft.terms.get(0);
        }
        return this.ft;
    }

    protected String[] split(String query) {
        return SEPARATOR.split(query);
    }

    protected boolean ignored(String word) {
        if (MINUS.equals(word) || PLUS.equals(word) || word.contains(DOUBLE_QUOTES)) {
            return false;
        }
        return IGNORED.matcher(word).matches();
    }

    protected void endAnd() {
        LinkedList<FulltextQuery> pos = new LinkedList<FulltextQuery>();
        LinkedList<FulltextQuery> neg = new LinkedList<FulltextQuery>();
        for (FulltextQuery term : this.terms) {
            if (term.op == Op.NOTWORD) {
                neg.add(term);
                continue;
            }
            pos.add(term);
        }
        if (!pos.isEmpty()) {
            this.terms = pos;
            this.terms.addAll(neg);
            if (this.terms.size() == 1) {
                this.ft.terms.add(this.terms.get(0));
            } else {
                FulltextQuery a = new FulltextQuery();
                a.op = Op.AND;
                a.terms = this.terms;
                this.ft.terms.add(a);
            }
        }
        this.terms = new LinkedList<FulltextQuery>();
    }

    public static void translate(FulltextQuery ft, StringBuilder buf, String or, String and, String andNot, String wordStart, String wordEnd, Set<Character> wordCharsReserved, String phraseStart, String phraseEnd, boolean quotePhraseWords) {
        if (ft.op == Op.AND || ft.op == Op.OR) {
            buf.append('(');
            for (int i = 0; i < ft.terms.size(); ++i) {
                FulltextQuery term = ft.terms.get(i);
                if (i > 0) {
                    buf.append(' ');
                    if (ft.op == Op.OR) {
                        buf.append(or);
                    } else if (term.op == Op.NOTWORD) {
                        buf.append(andNot);
                    } else {
                        buf.append(and);
                    }
                    buf.append(' ');
                }
                FulltextQueryAnalyzer.translate(term, buf, or, and, andNot, wordStart, wordEnd, wordCharsReserved, phraseStart, phraseEnd, quotePhraseWords);
            }
            buf.append(')');
            return;
        }
        String word = ft.word;
        if (ft.isPhrase()) {
            if (quotePhraseWords) {
                boolean first = true;
                for (String w : word.split(SPACE)) {
                    if (!first) {
                        buf.append(SPACE);
                    }
                    first = false;
                    FulltextQueryAnalyzer.appendWord(w, buf, wordStart, wordEnd, wordCharsReserved);
                }
            } else {
                buf.append(phraseStart);
                buf.append(word);
                buf.append(phraseEnd);
            }
        } else {
            FulltextQueryAnalyzer.appendWord(word, buf, wordStart, wordEnd, wordCharsReserved);
        }
    }

    protected static void appendWord(String word, StringBuilder buf, String start, String end, Set<Character> reserved) {
        boolean quote = true;
        if (!reserved.isEmpty()) {
            for (char c : word.toCharArray()) {
                if (!reserved.contains(Character.valueOf(c))) continue;
                quote = false;
                break;
            }
        }
        if (quote) {
            buf.append(start);
        }
        buf.append(word);
        if (quote) {
            buf.append(end);
        }
    }

    public static boolean hasPhrase(FulltextQuery ft) {
        if (ft.op == Op.AND || ft.op == Op.OR) {
            for (FulltextQuery term : ft.terms) {
                if (!FulltextQueryAnalyzer.hasPhrase(term)) continue;
                return true;
            }
            return false;
        }
        return ft.isPhrase();
    }

    public static FulltextQuery analyzeFulltextQuery(String query) {
        return new FulltextQueryAnalyzer().analyze(query);
    }

    public static String translateFulltext(FulltextQuery ft, String or, String and, String andNot, String phraseQuote) {
        StringBuilder buf = new StringBuilder();
        FulltextQueryAnalyzer.translate(ft, buf, or, and, andNot, "", "", Collections.emptySet(), phraseQuote, phraseQuote, false);
        return buf.toString();
    }

    public static String translateFulltext(FulltextQuery ft, String or, String and, String andNot, String wordStart, String wordEnd, Set<Character> wordCharsReserved, String phraseStart, String phraseEnd, boolean quotePhraseWords) {
        StringBuilder buf = new StringBuilder();
        FulltextQueryAnalyzer.translate(ft, buf, or, and, andNot, wordStart, wordEnd, wordCharsReserved, phraseStart, phraseEnd, quotePhraseWords);
        return buf.toString();
    }

    public static class FulltextQuery {
        public Op op;
        public List<FulltextQuery> terms;
        public String word;

        public boolean isPhrase() {
            return this.word != null && this.word.contains(FulltextQueryAnalyzer.SPACE);
        }
    }

    public static enum Op {
        OR,
        AND,
        WORD,
        NOTWORD;

    }
}

